/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolFactory;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.client.ClientCacheFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class PoolFactoryBean
implements FactoryBean<Pool>,
InitializingBean,
DisposableBean,
BeanNameAware,
BeanFactoryAware {
    private static final Log log = LogFactory.getLog(PoolFactoryBean.class);
    private boolean internalPool = true;
    private Pool pool;
    private String beanName;
    private String name;
    private Collection<InetSocketAddress> locators;
    private Collection<InetSocketAddress> servers;
    private BeanFactory beanFactory;
    private boolean keepAlive = false;
    private int freeConnectionTimeout = 10000;
    private long idleTimeout = 5000L;
    private int loadConditioningInterval = 300000;
    private int maxConnections = -1;
    private int minConnections = 1;
    private boolean multiUserAuthentication = false;
    private long pingInterval = 10000L;
    private boolean prSingleHopEnabled = true;
    private int readTimeout = 10000;
    private int retryAttempts = -1;
    private String serverGroup = "";
    private int socketBufferSize = 32768;
    private int statisticInterval = -1;
    private int subscriptionAckInterval = 100;
    private boolean subscriptionEnabled = false;
    private int subscriptionMessageTrackingTimeout = 900000;
    private int subscriptionRedundancy = 0;
    private boolean threadLocalConnections = false;

    public Class<?> getObjectType() {
        return this.pool != null ? this.pool.getClass() : Pool.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public Pool getObject() throws Exception {
        return this.pool;
    }

    public void afterPropertiesSet() throws Exception {
        Pool existingPool;
        if (!StringUtils.hasText((String)this.name)) {
            Assert.hasText((String)this.beanName, (String)"the pool name is required");
            this.name = this.beanName;
        }
        if (InternalDistributedSystem.getAnyInstance() == null) {
            Properties properties = null;
            try {
                ClientCacheFactoryBean clientCacheFactoryBean = (ClientCacheFactoryBean)this.beanFactory.getBean(ClientCacheFactoryBean.class);
                properties = clientCacheFactoryBean.getProperties();
            }
            catch (Exception e) {
                // empty catch block
            }
            PoolFactoryBean.connectToTemporaryDs(properties);
        }
        if ((existingPool = PoolManager.find((String)this.name)) != null) {
            this.pool = existingPool;
            this.internalPool = false;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Pool '" + this.name + " already exists; using found instance..."));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No pool named '" + this.name + "' found. Creating a new once..."));
            }
            if (CollectionUtils.isEmpty(this.locators) && CollectionUtils.isEmpty(this.servers)) {
                throw new IllegalArgumentException("at least one locator or server is required");
            }
            this.internalPool = true;
            PoolFactory poolFactory = PoolManager.createFactory();
            if (!CollectionUtils.isEmpty(this.locators)) {
                for (InetSocketAddress connection : this.locators) {
                    poolFactory.addLocator(connection.getHostName(), connection.getPort());
                }
            }
            if (!CollectionUtils.isEmpty(this.servers)) {
                for (InetSocketAddress connection : this.servers) {
                    poolFactory.addServer(connection.getHostName(), connection.getPort());
                }
            }
            poolFactory.setFreeConnectionTimeout(this.freeConnectionTimeout);
            poolFactory.setIdleTimeout(this.idleTimeout);
            poolFactory.setLoadConditioningInterval(this.loadConditioningInterval);
            poolFactory.setMaxConnections(this.maxConnections);
            poolFactory.setMinConnections(this.minConnections);
            poolFactory.setMultiuserAuthentication(this.multiUserAuthentication);
            poolFactory.setPingInterval(this.pingInterval);
            poolFactory.setPRSingleHopEnabled(this.prSingleHopEnabled);
            poolFactory.setReadTimeout(this.readTimeout);
            poolFactory.setRetryAttempts(this.retryAttempts);
            poolFactory.setServerGroup(this.serverGroup);
            poolFactory.setSocketBufferSize(this.socketBufferSize);
            poolFactory.setStatisticInterval(this.statisticInterval);
            poolFactory.setSubscriptionEnabled(this.subscriptionEnabled);
            poolFactory.setSubscriptionAckInterval(this.subscriptionAckInterval);
            poolFactory.setSubscriptionMessageTrackingTimeout(this.subscriptionMessageTrackingTimeout);
            poolFactory.setSubscriptionRedundancy(this.subscriptionRedundancy);
            poolFactory.setThreadLocalConnections(this.threadLocalConnections);
            this.pool = poolFactory.create(this.name);
        }
    }

    public void destroy() throws Exception {
        if (this.internalPool && this.pool != null && !this.pool.isDestroyed()) {
            this.pool.releaseThreadLocalConnection();
            this.pool.destroy(this.keepAlive);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Destroyed pool '" + this.name + "'..."));
            }
        }
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLocators(Collection<InetSocketAddress> locators) {
        this.locators = locators;
    }

    public void setServers(Collection<InetSocketAddress> servers) {
        this.servers = servers;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public void setFreeConnectionTimeout(int freeConnectionTimeout) {
        this.freeConnectionTimeout = freeConnectionTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public void setLoadConditioningInterval(int loadConditioningInterval) {
        this.loadConditioningInterval = loadConditioningInterval;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public void setMinConnections(int minConnections) {
        this.minConnections = minConnections;
    }

    public void setPingInterval(long pingInterval) {
        this.pingInterval = pingInterval;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public void setRetryAttempts(int retryAttempts) {
        this.retryAttempts = retryAttempts;
    }

    public void setServerGroup(String serverGroup) {
        this.serverGroup = serverGroup;
    }

    public void setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public void setStatisticInterval(int statisticInterval) {
        this.statisticInterval = statisticInterval;
    }

    public void setSubscriptionAckInterval(int subscriptionAckInterval) {
        this.subscriptionAckInterval = subscriptionAckInterval;
    }

    public void setSubscriptionEnabled(boolean subscriptionEnabled) {
        this.subscriptionEnabled = subscriptionEnabled;
    }

    public void setSubscriptionMessageTrackingTimeout(int subscriptionMessageTrackingTimeout) {
        this.subscriptionMessageTrackingTimeout = subscriptionMessageTrackingTimeout;
    }

    public void setSubscriptionRedundancy(int subscriptionRedundancy) {
        this.subscriptionRedundancy = subscriptionRedundancy;
    }

    public void setThreadLocalConnections(boolean threadLocalConnections) {
        this.threadLocalConnections = threadLocalConnections;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public void setMultiUserAuthentication(boolean multiUserAuthentication) {
        this.multiUserAuthentication = multiUserAuthentication;
    }

    public void setPrSingleHopEnabled(boolean prSingleHopEnabled) {
        this.prSingleHopEnabled = prSingleHopEnabled;
    }

    static void connectToTemporaryDs(Properties properties) {
        Properties props = properties != null ? (Properties)properties.clone() : new Properties();
        props.setProperty("mcast-port", "0");
        props.setProperty("locators", "");
        DistributedSystem.connect((Properties)props);
    }
}

