/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import com.gemstone.gemfire.internal.datasource.ConfigProperty;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.data.gemfire.config.PdxDiskStoreAwareBeanFactoryPostProcessor;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

class CacheParser
extends AbstractSimpleBeanDefinitionParser {
    CacheParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return CacheFactoryBean.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element function;
        Element gatewayConflictResolver;
        Element txWriter;
        super.doParse(element, builder);
        ParsingUtils.setPropertyValue(element, builder, "cache-xml-location", "cacheXml");
        ParsingUtils.setPropertyReference(element, builder, "properties-ref", "properties");
        ParsingUtils.setPropertyReference(element, builder, "pdx-serializer-ref", "pdxSerializer");
        this.parsePdxDiskStore(element, parserContext, builder);
        ParsingUtils.setPropertyValue(element, builder, "pdx-persistent");
        ParsingUtils.setPropertyValue(element, builder, "pdx-read-serialized");
        ParsingUtils.setPropertyValue(element, builder, "pdx-ignore-unread-fields");
        ParsingUtils.setPropertyValue(element, builder, "use-bean-factory-locator");
        ParsingUtils.setPropertyValue(element, builder, "copy-on-read");
        ParsingUtils.setPropertyValue(element, builder, "lock-timeout");
        ParsingUtils.setPropertyValue(element, builder, "lock-lease");
        ParsingUtils.setPropertyValue(element, builder, "message-sync-interval");
        ParsingUtils.setPropertyValue(element, builder, "search-timeout");
        ParsingUtils.setPropertyValue(element, builder, "critical-heap-percentage");
        ParsingUtils.setPropertyValue(element, builder, "eviction-heap-percentage");
        ParsingUtils.setPropertyValue(element, builder, "close");
        ParsingUtils.setPropertyValue(element, builder, "lazy-init", "lazyInitialize");
        List txListeners = DomUtils.getChildElementsByTagName((Element)element, (String)"transaction-listener");
        if (!CollectionUtils.isEmpty((Collection)txListeners)) {
            ManagedList transactionListeners = new ManagedList();
            for (Element txListener : txListeners) {
                transactionListeners.add(ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, txListener, builder));
            }
            builder.addPropertyValue("transactionListeners", (Object)transactionListeners);
        }
        if ((txWriter = DomUtils.getChildElementByTagName((Element)element, (String)"transaction-writer")) != null) {
            builder.addPropertyValue("transactionWriter", ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, txWriter, builder));
        }
        if ((gatewayConflictResolver = DomUtils.getChildElementByTagName((Element)element, (String)"gateway-conflict-resolver")) != null) {
            ParsingUtils.throwExceptionIfNotGemfireV7(element.getLocalName(), "gateway-conflict-resolver", parserContext);
            builder.addPropertyValue("gatewayConflictResolver", ParsingUtils.parseRefOrSingleNestedBeanDeclaration(parserContext, gatewayConflictResolver, builder));
        }
        if ((function = DomUtils.getChildElementByTagName((Element)element, (String)"function")) != null) {
            builder.addPropertyValue("functions", ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, function, builder));
        }
        this.parseDynamicRegionFactory(element, builder);
        this.parseJndiBindings(element, builder);
    }

    private void parsePdxDiskStore(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        ParsingUtils.setPropertyValue(element, builder, "pdx-disk-store", "pdxDiskStoreName");
        String pdxDiskStoreName = element.getAttribute("pdx-disk-store");
        if (!StringUtils.isEmpty((Object)pdxDiskStoreName)) {
            this.registerPdxDiskStoreAwareBeanFactoryPostProcessor(parserContext, pdxDiskStoreName);
        }
    }

    private void registerPdxDiskStoreAwareBeanFactoryPostProcessor(ParserContext parserContext, String pdxDiskStoreName) {
        BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)this.createPdxDiskStoreAwareBeanFactoryPostProcessorBeanDefinition(pdxDiskStoreName), (BeanDefinitionRegistry)parserContext.getRegistry());
    }

    private AbstractBeanDefinition createPdxDiskStoreAwareBeanFactoryPostProcessorBeanDefinition(String pdxDiskStoreName) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(PdxDiskStoreAwareBeanFactoryPostProcessor.class);
        builder.addConstructorArgValue((Object)pdxDiskStoreName);
        return builder.getBeanDefinition();
    }

    private void parseDynamicRegionFactory(Element element, BeanDefinitionBuilder builder) {
        Element dynamicRegionFactory = DomUtils.getChildElementByTagName((Element)element, (String)"dynamic-region-factory");
        if (dynamicRegionFactory != null) {
            BeanDefinitionBuilder dynamicRegionSupport = this.buildDynamicRegionSupport(dynamicRegionFactory);
            this.postProcessDynamicRegionSupport(element, dynamicRegionSupport);
            builder.addPropertyValue("dynamicRegionSupport", (Object)dynamicRegionSupport.getBeanDefinition());
        }
    }

    protected void postProcessDynamicRegionSupport(Element element, BeanDefinitionBuilder dynamicRegionSupport) {
    }

    private BeanDefinitionBuilder buildDynamicRegionSupport(Element dynamicRegionFactory) {
        BeanDefinitionBuilder result = null;
        if (dynamicRegionFactory != null) {
            String registerInterest;
            String persistent;
            BeanDefinitionBuilder dynamicRegionSupport = BeanDefinitionBuilder.genericBeanDefinition(CacheFactoryBean.DynamicRegionSupport.class);
            String diskDir = dynamicRegionFactory.getAttribute("disk-dir");
            if (StringUtils.hasText((String)diskDir)) {
                dynamicRegionSupport.addPropertyValue("diskDir", (Object)diskDir);
            }
            if (StringUtils.hasText((String)(persistent = dynamicRegionFactory.getAttribute("persistent")))) {
                dynamicRegionSupport.addPropertyValue("persistent", (Object)persistent);
            }
            if (StringUtils.hasText((String)(registerInterest = dynamicRegionFactory.getAttribute("register-interest")))) {
                dynamicRegionSupport.addPropertyValue("registerInterest", (Object)registerInterest);
            }
            result = dynamicRegionSupport;
        }
        return result;
    }

    private void parseJndiBindings(Element element, BeanDefinitionBuilder builder) {
        List jndiBindings = DomUtils.getChildElementsByTagName((Element)element, (String)"jndi-binding");
        if (!CollectionUtils.isEmpty((Collection)jndiBindings)) {
            ManagedList jndiDataSources = new ManagedList();
            ManagedMap jndiAttributes = new ManagedMap();
            for (Element jndiBinding : jndiBindings) {
                BeanDefinitionBuilder jndiDataSource = BeanDefinitionBuilder.genericBeanDefinition(CacheFactoryBean.JndiDataSource.class);
                NamedNodeMap nnm = jndiBinding.getAttributes();
                for (int i = 0; i < nnm.getLength(); ++i) {
                    Attr attr = (Attr)nnm.item(i);
                    jndiAttributes.put((Object)attr.getLocalName(), (Object)attr.getValue());
                }
                jndiDataSource.addPropertyValue("attributes", (Object)jndiAttributes);
                List jndiProps = DomUtils.getChildElementsByTagName((Element)element, (String)"jndi-prop");
                if (!CollectionUtils.isEmpty((Collection)jndiProps)) {
                    ManagedList props = new ManagedList();
                    for (Element jndiProp : jndiProps) {
                        String key = jndiProp.getAttribute("key");
                        String value = jndiProp.getNodeValue();
                        String type = StringUtils.hasText((String)jndiProp.getAttribute("type")) ? jndiProp.getAttribute("type") : String.class.getName();
                        props.add((Object)new ConfigProperty(key, value, type));
                    }
                    jndiDataSource.addPropertyValue("props", (Object)props);
                }
                jndiDataSources.add((Object)jndiDataSource.getBeanDefinition());
            }
            builder.addPropertyValue("jndiDataSources", (Object)jndiDataSources);
        }
    }

    protected String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) throws BeanDefinitionStoreException {
        String name = super.resolveId(element, definition, parserContext);
        if (!StringUtils.hasText((String)name)) {
            name = "gemfireCache";
            parserContext.getRegistry().registerAlias("gemfireCache", "gemfire-cache");
        }
        return name;
    }
}

