/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.wan;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.util.Gateway;
import com.gemstone.gemfire.cache.util.GatewayEventListener;
import com.gemstone.gemfire.cache.util.GatewayHub;
import com.gemstone.gemfire.cache.util.GatewayQueueAttributes;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.springframework.data.gemfire.wan.AbstractWANComponentFactoryBean;
import org.springframework.data.gemfire.wan.GatewayProxy;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class GatewayHubFactoryBean
extends AbstractWANComponentFactoryBean<GatewayHub> {
    private static List<String> validStartupPolicyValues = Arrays.asList("none", "primary", "secondary");
    private static List<String> validOrderPolicyValues = Arrays.asList("KEY,PARTITION,THREAD");
    private GatewayHub gatewayHub;
    private Integer port;
    private String bindAddress;
    private Integer maximumTimeBetweenPings;
    private Integer socketBufferSize;
    private String startupPolicy;
    private Boolean manualStart;
    private List<GatewayProxy> gateways;

    public GatewayHubFactoryBean(Cache cache) {
        super(cache);
    }

    @Override
    public GatewayHub getObject() throws Exception {
        return this.gatewayHub;
    }

    @Override
    public Class<?> getObjectType() {
        return GatewayHub.class;
    }

    @Override
    protected void doInit() {
        String name = this.getName();
        this.gatewayHub = this.cache.addGatewayHub(name, this.port == null ? -1 : this.port);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("added gateway hub " + name));
        }
        Assert.notNull((Object)this.cache.getGatewayHub(name));
        if (this.bindAddress != null) {
            this.gatewayHub.setBindAddress(this.bindAddress);
        }
        if (this.manualStart != null) {
            this.gatewayHub.setManualStart(this.manualStart.booleanValue());
        }
        if (this.socketBufferSize != null) {
            this.gatewayHub.setSocketBufferSize(this.socketBufferSize.intValue());
        }
        if (this.startupPolicy != null) {
            Assert.isTrue((boolean)validStartupPolicyValues.contains(this.startupPolicy), (String)("The value of startup policy:'" + this.startupPolicy + "' is invalid"));
            this.gatewayHub.setStartupPolicy(this.startupPolicy);
        }
        if (this.maximumTimeBetweenPings != null) {
            this.gatewayHub.setMaximumTimeBetweenPings(this.maximumTimeBetweenPings.intValue());
        }
        if (!CollectionUtils.isEmpty(this.gateways)) {
            this.configureGateways();
        }
        if (!this.gatewayHub.getManualStart()) {
            try {
                this.gatewayHub.start();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setMaximumTimeBetweenPings(Integer maximumTimeBetweenPings) {
        this.maximumTimeBetweenPings = maximumTimeBetweenPings;
    }

    public void setSocketBufferSize(Integer socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
    }

    public void setStartupPolicy(String startupPolicy) {
        this.startupPolicy = startupPolicy;
    }

    public void setManualStart(Boolean manualStart) {
        this.manualStart = manualStart;
    }

    public void setGateways(List<GatewayProxy> gateways) {
        this.gateways = gateways;
    }

    private void configureGateways() {
        for (GatewayProxy gateway : this.gateways) {
            Gateway gw = this.gatewayHub.addGateway(gateway.getId(), gateway.getConcurrencyLevel() == null ? 1 : gateway.getConcurrencyLevel());
            if (!CollectionUtils.isEmpty(gateway.getEndpoints())) {
                for (GatewayProxy.GatewayEndpoint endpoint : gateway.getEndpoints()) {
                    gw.addEndpoint(endpoint.getId(), endpoint.getHost(), endpoint.getPort());
                }
            }
            if (!CollectionUtils.isEmpty(gateway.getListeners())) {
                for (GatewayEventListener listener : gateway.getListeners()) {
                    gw.addListener(listener);
                }
            }
            if (gateway.getOrderPolicy() != null) {
                Assert.isTrue((boolean)validOrderPolicyValues.contains(gateway.getOrderPolicy()), (String)("The value of order policy:'" + gateway.getOrderPolicy() + "' is invalid"));
                gw.setOrderPolicy(Gateway.OrderPolicy.valueOf((String)gateway.getOrderPolicy()));
            }
            if (gateway.getSocketBufferSize() != null) {
                gw.setSocketBufferSize(gateway.getSocketBufferSize().intValue());
            }
            if (gateway.getQueue() == null) continue;
            GatewayProxy.GatewayQueue queue = gateway.getQueue();
            GatewayQueueAttributes queueAttributes = gw.getQueueAttributes();
            if (queue.getAlertThreshold() != null) {
                queueAttributes.setAlertThreshold(queue.getAlertThreshold().intValue());
            }
            if (queue.getEnableBatchConflation() != null) {
                queueAttributes.setBatchConflation(queue.getEnableBatchConflation().booleanValue());
            }
            if (queue.getBatchSize() != null) {
                queueAttributes.setBatchSize(queue.getBatchSize().intValue());
            }
            if (queue.getBatchTimeInterval() != null) {
                queueAttributes.setBatchTimeInterval(queue.getBatchTimeInterval().intValue());
            }
            if (queue.getDiskStoreRef() != null) {
                boolean persistent = queue.getPersistent() == null ? Boolean.TRUE : queue.getPersistent();
                Assert.isTrue((boolean)persistent, (String)"specifying a disk store requires persistent property to be true");
                queueAttributes.setDiskStoreName(queue.getDiskStoreRef());
            }
            if (queue.getPersistent() != null) {
                queueAttributes.setEnablePersistence(queue.getPersistent().booleanValue());
            }
            if (queue.getMaximumQueueMemory() == null) continue;
            queueAttributes.setMaximumQueueMemory(queue.getMaximumQueueMemory().intValue());
        }
    }
}

