/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.GemFireCheckedException;
import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.DynamicRegionFactory;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.TransactionListener;
import com.gemstone.gemfire.cache.TransactionWriter;
import com.gemstone.gemfire.cache.util.GatewayConflictResolver;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.internal.datasource.ConfigProperty;
import com.gemstone.gemfire.internal.jndi.JNDIInvoker;
import com.gemstone.gemfire.pdx.PdxSerializer;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.gemfire.GemfireBeanFactoryLocator;
import org.springframework.data.gemfire.GemfireCacheUtils;
import org.springframework.data.gemfire.GemfireSystemException;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;

public class CacheFactoryBean
implements BeanNameAware,
BeanFactoryAware,
BeanClassLoaderAware,
InitializingBean,
DisposableBean,
FactoryBean<Cache>,
PersistenceExceptionTranslator {
    protected static final List<String> VALID_JNDI_DATASOURCE_TYPE_NAMES = Collections.unmodifiableList(Arrays.asList("ManagedDataSource", "PooledDataSource", "SimpleDataSource", "XAPooledDataSource"));
    protected boolean close = true;
    protected boolean lazyInitialize = true;
    protected boolean useBeanFactoryLocator = true;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected BeanFactory beanFactory;
    protected Boolean copyOnRead;
    protected Boolean pdxIgnoreUnreadFields;
    protected Boolean pdxPersistent;
    protected Boolean pdxReadSerialized;
    protected Cache cache;
    protected ClassLoader beanClassLoader;
    protected DynamicRegionSupport dynamicRegionSupport;
    protected Float criticalHeapPercentage;
    protected Float evictionHeapPercentage;
    protected GemfireBeanFactoryLocator factoryLocator;
    protected Integer lockLease;
    protected Integer lockTimeout;
    protected Integer messageSyncInterval;
    protected Integer searchTimeout;
    protected List<JndiDataSource> jndiDataSources;
    protected List<TransactionListener> transactionListeners;
    protected Object gatewayConflictResolver;
    protected Object pdxSerializer;
    protected Properties properties;
    protected Resource cacheXml;
    protected String beanName;
    protected String pdxDiskStoreName;
    protected TransactionWriter transactionWriter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws Exception {
        if (this.useBeanFactoryLocator && this.factoryLocator == null) {
            this.factoryLocator = new GemfireBeanFactoryLocator();
            this.factoryLocator.setBeanFactory(this.beanFactory);
            this.factoryLocator.setBeanName(this.beanName);
            this.factoryLocator.afterPropertiesSet();
        }
        ClassLoader originalThreadContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            String messagePrefix;
            Thread.currentThread().setContextClassLoader(this.beanClassLoader);
            try {
                this.cache = (Cache)this.fetchCache();
                messagePrefix = "Retrieved existing";
            }
            catch (CacheClosedException ex) {
                this.initializeDynamicRegionFactory();
                Object factory = this.createFactory(this.properties);
                if (this.isPdxSettingsSpecified()) {
                    Assert.isTrue((boolean)ClassUtils.isPresent((String)"com.gemstone.gemfire.pdx.PdxSerializer", (ClassLoader)this.beanClassLoader), (String)"Cannot set PDX options since GemFire 6.6 not detected.");
                    this.applyPdxOptions(factory);
                }
                this.cache = (Cache)this.createCache(factory);
                messagePrefix = "Created new";
            }
            if (this.copyOnRead != null) {
                this.cache.setCopyOnRead(this.copyOnRead.booleanValue());
            }
            if (this.lockLease != null) {
                this.cache.setLockLease(this.lockLease.intValue());
            }
            if (this.lockTimeout != null) {
                this.cache.setLockTimeout(this.lockTimeout.intValue());
            }
            if (this.searchTimeout != null) {
                this.cache.setSearchTimeout(this.searchTimeout.intValue());
            }
            if (this.messageSyncInterval != null) {
                this.cache.setMessageSyncInterval(this.messageSyncInterval.intValue());
            }
            if (this.gatewayConflictResolver != null) {
                this.cache.setGatewayConflictResolver((GatewayConflictResolver)this.gatewayConflictResolver);
            }
            DistributedSystem system = this.cache.getDistributedSystem();
            DistributedMember member = system.getDistributedMember();
            this.log.info((Object)String.format("Connected to Distributed System [%1$s] as Member [%2$s] on Host [%3$s].", system.getName(), member.getId(), member.getHost()));
            this.log.info((Object)String.format("%1$s GemFire v.%2$s Cache [%3$s].", messagePrefix, CacheFactory.getVersion(), this.cache.getName()));
            if (this.cacheXml != null) {
                this.cache.loadCacheXml(this.cacheXml.getInputStream());
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Initialized cache from " + this.cacheXml));
                }
            }
            this.setHeapPercentages();
            this.registerTransactionListeners();
            this.registerTransactionWriter();
            this.registerJndiDataSources();
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalThreadContextClassLoader);
        }
    }

    private boolean isPdxSettingsSpecified() {
        return this.pdxSerializer != null || this.pdxPersistent != null || this.pdxReadSerialized != null || this.pdxIgnoreUnreadFields != null || this.pdxDiskStoreName != null;
    }

    protected void applyPdxOptions(Object factory) {
        if (factory instanceof CacheFactory) {
            new PdxOptions((CacheFactory)factory).run();
        }
    }

    private void initializeDynamicRegionFactory() {
        if (this.dynamicRegionSupport != null) {
            this.dynamicRegionSupport.initializeDynamicRegionFactory();
        }
    }

    protected void registerTransactionListeners() {
        if (!CollectionUtils.isEmpty(this.transactionListeners)) {
            for (TransactionListener transactionListener : this.transactionListeners) {
                this.cache.getCacheTransactionManager().addListener(transactionListener);
            }
        }
    }

    protected void registerTransactionWriter() {
        if (this.transactionWriter != null) {
            this.cache.getCacheTransactionManager().setWriter(this.transactionWriter);
        }
    }

    private void registerJndiDataSources() {
        if (this.jndiDataSources != null) {
            for (JndiDataSource jndiDataSource : this.jndiDataSources) {
                this.validate(jndiDataSource);
                JNDIInvoker.mapDatasource(jndiDataSource.getAttributes(), jndiDataSource.getProps());
            }
        }
    }

    private void validate(JndiDataSource jndiDataSource) {
        Map<String, String> attributes = jndiDataSource.getAttributes();
        String typeAttributeValue = attributes.get("type");
        Assert.isTrue((boolean)VALID_JNDI_DATASOURCE_TYPE_NAMES.contains(typeAttributeValue), (String)String.format("The 'jndi-binding', 'type' [%1$s] is invalid; the 'type' must be one of %2$s.", typeAttributeValue, VALID_JNDI_DATASOURCE_TYPE_NAMES));
    }

    private void setHeapPercentages() {
        if (this.criticalHeapPercentage != null) {
            Assert.isTrue(((double)this.criticalHeapPercentage.floatValue() > 0.0 && (double)this.criticalHeapPercentage.floatValue() <= 100.0 ? 1 : 0) != 0, (String)String.format("Invalid value specified for 'criticalHeapPercentage' (%1$s). Must be > 0.0 and <= 100.0.", this.criticalHeapPercentage));
            this.cache.getResourceManager().setCriticalHeapPercentage(this.criticalHeapPercentage.floatValue());
        }
        if (this.evictionHeapPercentage != null) {
            Assert.isTrue(((double)this.evictionHeapPercentage.floatValue() > 0.0 && (double)this.evictionHeapPercentage.floatValue() <= 100.0 ? 1 : 0) != 0, (String)String.format("Invalid value specified for 'evictionHeapPercentage' (%1$s). Must be > 0.0 and <= 100.0.", this.evictionHeapPercentage));
            this.cache.getResourceManager().setEvictionHeapPercentage(this.evictionHeapPercentage.floatValue());
        }
    }

    protected GemFireCache createCache(Object factory) {
        return this.cache != null ? this.cache : ((CacheFactory)factory).create();
    }

    protected GemFireCache fetchCache() {
        return this.cache != null ? this.cache : CacheFactory.getAnyInstance();
    }

    protected Object createFactory(Properties props) {
        return new CacheFactory(props);
    }

    public void destroy() throws Exception {
        if (this.close) {
            if (this.cache != null && !this.cache.isClosed()) {
                this.cache.close();
            }
            this.cache = null;
            if (this.factoryLocator != null) {
                this.factoryLocator.destroy();
                this.factoryLocator = null;
            }
        }
    }

    public DataAccessException translateExceptionIfPossible(RuntimeException ex) {
        DataAccessException wrapped;
        if (ex instanceof GemFireException) {
            return GemfireCacheUtils.convertGemfireAccessException((GemFireException)ex);
        }
        if (ex instanceof IllegalArgumentException && !((wrapped = GemfireCacheUtils.convertQueryExceptions(ex)) instanceof GemfireSystemException)) {
            return wrapped;
        }
        if (ex.getCause() instanceof GemFireException) {
            return GemfireCacheUtils.convertGemfireAccessException((GemFireException)ex.getCause());
        }
        if (ex.getCause() instanceof GemFireCheckedException) {
            return GemfireCacheUtils.convertGemfireAccessException((GemFireCheckedException)ex.getCause());
        }
        return null;
    }

    public Cache getObject() throws Exception {
        this.init();
        return this.cache;
    }

    public Class<? extends Cache> getObjectType() {
        return this.cache != null ? this.cache.getClass() : Cache.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setCacheXml(Resource cacheXml) {
        this.cacheXml = cacheXml;
    }

    public void setUseBeanFactoryLocator(boolean usage) {
        this.useBeanFactoryLocator = usage;
    }

    public void setPdxSerializer(Object serializer) {
        this.pdxSerializer = serializer;
    }

    public void setPdxPersistent(Boolean pdxPersistent) {
        this.pdxPersistent = pdxPersistent;
    }

    public void setPdxReadSerialized(Boolean pdxReadSerialized) {
        this.pdxReadSerialized = pdxReadSerialized;
    }

    public void setPdxIgnoreUnreadFields(Boolean pdxIgnoreUnreadFields) {
        this.pdxIgnoreUnreadFields = pdxIgnoreUnreadFields;
    }

    public void setPdxDiskStoreName(String pdxDiskStoreName) {
        this.pdxDiskStoreName = pdxDiskStoreName;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setCopyOnRead(Boolean copyOnRead) {
        this.copyOnRead = copyOnRead;
    }

    public void setLockTimeout(Integer lockTimeout) {
        this.lockTimeout = lockTimeout;
    }

    public void setLockLease(Integer lockLease) {
        this.lockLease = lockLease;
    }

    public void setMessageSyncInterval(Integer messageSyncInterval) {
        this.messageSyncInterval = messageSyncInterval;
    }

    public void setSearchTimeout(Integer searchTimeout) {
        this.searchTimeout = searchTimeout;
    }

    public void setEvictionHeapPercentage(Float evictionHeapPercentage) {
        this.evictionHeapPercentage = evictionHeapPercentage;
    }

    public void setCriticalHeapPercentage(Float criticalHeapPercentage) {
        this.criticalHeapPercentage = criticalHeapPercentage;
    }

    public void setClose(boolean close) {
        this.close = close;
    }

    public void setTransactionListeners(List<TransactionListener> transactionListeners) {
        this.transactionListeners = transactionListeners;
    }

    public void setTransactionWriter(TransactionWriter transactionWriter) {
        this.transactionWriter = transactionWriter;
    }

    public void setGatewayConflictResolver(Object gatewayConflictResolver) {
        this.gatewayConflictResolver = gatewayConflictResolver;
    }

    public void setDynamicRegionSupport(DynamicRegionSupport dynamicRegionSupport) {
        this.dynamicRegionSupport = dynamicRegionSupport;
    }

    public void setJndiDataSources(List<JndiDataSource> jndiDataSources) {
        this.jndiDataSources = jndiDataSources;
    }

    public List<JndiDataSource> getJndiDataSources() {
        return this.jndiDataSources;
    }

    public void setLazyInitialize(boolean lazyInitialize) {
        this.lazyInitialize = lazyInitialize;
    }

    public Resource getCacheXml() {
        return this.cacheXml;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ClassLoader getBeanClassLoader() {
        return this.beanClassLoader;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public Object getPdxSerializer() {
        return this.pdxSerializer;
    }

    public Boolean getPdxPersistent() {
        return this.pdxPersistent;
    }

    public Boolean getPdxReadSerialized() {
        return this.pdxReadSerialized;
    }

    public Boolean getPdxIgnoreUnreadFields() {
        return this.pdxIgnoreUnreadFields;
    }

    public String getPdxDiskStoreName() {
        return this.pdxDiskStoreName;
    }

    public Boolean getCopyOnRead() {
        return this.copyOnRead;
    }

    public Integer getLockTimeout() {
        return this.lockTimeout;
    }

    public Integer getLockLease() {
        return this.lockLease;
    }

    public Integer getMessageSyncInterval() {
        return this.messageSyncInterval;
    }

    public Integer getSearchTimeout() {
        return this.searchTimeout;
    }

    public List<TransactionListener> getTransactionListeners() {
        return this.transactionListeners;
    }

    public TransactionWriter getTransactionWriter() {
        return this.transactionWriter;
    }

    public Float getEvictionHeapPercentage() {
        return this.evictionHeapPercentage;
    }

    public Float getCriticalHeapPercentage() {
        return this.criticalHeapPercentage;
    }

    public DynamicRegionSupport getDynamicRegionSupport() {
        return this.dynamicRegionSupport;
    }

    public Object getGatewayConflictResolver() {
        return this.gatewayConflictResolver;
    }

    public GemfireBeanFactoryLocator getBeanFactoryLocator() {
        return this.factoryLocator;
    }

    public boolean isLazyInitialize() {
        return this.lazyInitialize;
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.lazyInitialize) {
            this.init();
        }
    }

    private class PdxOptions
    implements Runnable {
        private final CacheFactory factory;

        PdxOptions(CacheFactory factory) {
            this.factory = factory;
        }

        @Override
        public void run() {
            if (CacheFactoryBean.this.pdxSerializer != null) {
                Assert.isAssignable(PdxSerializer.class, CacheFactoryBean.this.pdxSerializer.getClass(), (String)"Invalid pdx serializer used");
                this.factory.setPdxSerializer((PdxSerializer)CacheFactoryBean.this.pdxSerializer);
            }
            if (CacheFactoryBean.this.pdxDiskStoreName != null) {
                this.factory.setPdxDiskStore(CacheFactoryBean.this.pdxDiskStoreName);
            }
            if (CacheFactoryBean.this.pdxIgnoreUnreadFields != null) {
                this.factory.setPdxIgnoreUnreadFields(CacheFactoryBean.this.pdxIgnoreUnreadFields.booleanValue());
            }
            if (CacheFactoryBean.this.pdxPersistent != null) {
                this.factory.setPdxPersistent(CacheFactoryBean.this.pdxPersistent.booleanValue());
            }
            if (CacheFactoryBean.this.pdxReadSerialized != null) {
                this.factory.setPdxReadSerialized(CacheFactoryBean.this.pdxReadSerialized.booleanValue());
            }
        }
    }

    public static class JndiDataSource {
        private List<ConfigProperty> props;
        private Map<String, String> attributes;

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        public List<ConfigProperty> getProps() {
            return this.props;
        }

        public void setProps(List<ConfigProperty> props) {
            this.props = props;
        }
    }

    public static class DynamicRegionSupport {
        private String diskDir;
        private String poolName;
        private Boolean persistent = Boolean.TRUE;
        private Boolean registerInterest = Boolean.TRUE;

        public String getDiskDir() {
            return this.diskDir;
        }

        public void setDiskDir(String diskDir) {
            this.diskDir = diskDir;
        }

        public Boolean getPersistent() {
            return this.persistent;
        }

        public void setPersistent(Boolean persistent) {
            this.persistent = persistent;
        }

        public Boolean getRegisterInterest() {
            return this.registerInterest;
        }

        public void setRegisterInterest(Boolean registerInterest) {
            this.registerInterest = registerInterest;
        }

        public String getPoolName() {
            return this.poolName;
        }

        public void setPoolName(String poolName) {
            this.poolName = poolName;
        }

        public void initializeDynamicRegionFactory() {
            DynamicRegionFactory.Config config = null;
            config = this.diskDir == null ? new DynamicRegionFactory.Config(null, this.poolName, this.persistent.booleanValue(), this.registerInterest.booleanValue()) : new DynamicRegionFactory.Config(new File(this.diskDir), this.poolName, this.persistent.booleanValue(), this.registerInterest.booleanValue());
            DynamicRegionFactory.get().open(config);
        }
    }
}

