/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.client.GemfireDataSourcePostProcessor;
import org.springframework.data.gemfire.config.ClientCacheParser;
import org.springframework.data.gemfire.config.PoolParser;
import org.w3c.dom.Element;

public class GemfireDataSourceParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        AbstractBeanDefinition poolDefinition = (AbstractBeanDefinition)new PoolParser().parse(element, parserContext);
        MutablePropertyValues poolProperties = poolDefinition.getPropertyValues();
        poolProperties.add("name", (Object)"gemfirePool");
        if (!element.hasAttribute("subscription-enabled")) {
            poolProperties.add("subscriptionEnabled", (Object)true);
        }
        parserContext.getRegistry().registerBeanDefinition("gemfirePool", (BeanDefinition)poolDefinition);
        AbstractBeanDefinition clientCacheDefinition = (AbstractBeanDefinition)new ClientCacheParser().parse(element, parserContext);
        MutablePropertyValues clientCacheProperties = clientCacheDefinition.getPropertyValues();
        clientCacheProperties.add("pool", (Object)poolDefinition);
        parserContext.getRegistry().registerBeanDefinition("gemfireCache", (BeanDefinition)clientCacheDefinition);
        System.out.printf("Registered GemFire Client Cache bean '%1$s' of type '%2$s'%n", "gemfireCache", clientCacheDefinition.getBeanClassName());
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(GemfireDataSourcePostProcessor.class);
        builder.addConstructorArgReference("gemfireCache");
        BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)builder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        return null;
    }
}

