/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.data.gemfire.function.config.AbstractFunctionExecutionBeanDefinitionBuilder;
import org.springframework.data.gemfire.function.config.FunctionExecutionConfiguration;
import org.springframework.data.gemfire.function.execution.GemfireFunctionProxyFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class ServerBasedExecutionBeanDefinitionBuilder
extends AbstractFunctionExecutionBeanDefinitionBuilder {
    ServerBasedExecutionBeanDefinitionBuilder(FunctionExecutionConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected BeanDefinitionBuilder getGemfireOperationsBeanDefinitionBuilder(BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder functionTemplateBuilder = BeanDefinitionBuilder.genericBeanDefinition(this.getGemfireOperationsClass());
        String pool = (String)this.configuration.getAttribute("pool");
        String cache = (String)this.configuration.getAttribute("cache");
        Assert.state((!StringUtils.hasText((String)pool) || !StringUtils.hasText((String)cache) ? 1 : 0) != 0, (String)String.format("invalid configuration for interface %s. Cannot specify both 'pool' and 'cache'", this.configuration.getFunctionExecutionInterface().getName()));
        if (StringUtils.hasText((String)pool)) {
            functionTemplateBuilder.addConstructorArgReference(pool);
        } else {
            if (!StringUtils.hasText((String)cache)) {
                cache = "gemfireCache";
            }
            functionTemplateBuilder.addConstructorArgReference(cache);
        }
        return functionTemplateBuilder;
    }

    @Override
    protected Class<?> getFunctionProxyFactoryBeanClass() {
        return GemfireFunctionProxyFactoryBean.class;
    }

    protected abstract Class<?> getGemfireOperationsClass();
}

