/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.repository.query;

import com.gemstone.gemfire.cache.Region;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class QueryString {
    private static final String IN_PATTERN = "(?<=IN (SET|LIST) )\\$\\d";
    private static final String IN_PARAMETER_PATTERN = "(?<=IN (SET|LIST) \\$)\\d";
    private static final String REGION_PATTERN = "\\/(\\/?\\w)+";
    private final String query;

    public QueryString(String source) {
        Assert.hasText((String)source, (String)"The OQL statement (Query) to execute must be specified!");
        this.query = source;
    }

    public QueryString(Class<?> domainClass) {
        this(domainClass, false);
    }

    public QueryString(Class<?> domainClass, boolean isCountQuery) {
        this(String.format(isCountQuery ? "SELECT count(*) FROM /%s" : "SELECT * FROM /%s", domainClass.getSimpleName()));
    }

    public QueryString bindIn(Collection<?> values) {
        if (values != null) {
            String valueString = StringUtils.collectionToDelimitedString(values, (String)", ", (String)"'", (String)"'");
            return new QueryString(this.query.replaceFirst(IN_PATTERN, String.format("(%s)", valueString)));
        }
        return this;
    }

    public QueryString forRegion(Class<?> domainClass, Region<?, ?> region) {
        return new QueryString(this.query.replaceAll(REGION_PATTERN, region.getFullPath()));
    }

    public Iterable<Integer> getInParameterIndexes() {
        Pattern pattern = Pattern.compile(IN_PARAMETER_PATTERN);
        Matcher matcher = pattern.matcher(this.query);
        ArrayList<Integer> result = new ArrayList<Integer>();
        while (matcher.find()) {
            result.add(Integer.parseInt(matcher.group()));
        }
        return result;
    }

    public QueryString orderBy(Sort sort) {
        if (sort != null) {
            StringBuilder orderClause = new StringBuilder("ORDER BY ");
            int count = 0;
            for (Sort.Order order : sort) {
                orderClause.append(count++ > 0 ? ", " : "");
                orderClause.append(String.format("%1$s %2$s", order.getProperty(), order.getDirection()));
            }
            return new QueryString(String.format("%1$s %2$s", this.query, orderClause.toString()));
        }
        return this;
    }

    public String toString() {
        return this.query;
    }
}

