/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.GemFireCheckedException;
import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.query.IndexInvalidException;
import com.gemstone.gemfire.cache.query.Query;
import com.gemstone.gemfire.cache.query.QueryInvalidException;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.gemfire.GemfireAccessor;
import org.springframework.data.gemfire.GemfireCacheUtils;
import org.springframework.data.gemfire.GemfireCallback;
import org.springframework.data.gemfire.GemfireOperations;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class GemfireTemplate
extends GemfireAccessor
implements GemfireOperations {
    private boolean exposeNativeRegion = false;
    private Region<?, ?> regionProxy;

    public GemfireTemplate() {
    }

    public <K, V> GemfireTemplate(Region<K, V> region) {
        this.setRegion(region);
        this.afterPropertiesSet();
    }

    @Override
    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        this.regionProxy = this.createRegionProxy(this.getRegion());
    }

    public void setExposeNativeRegion(boolean exposeNativeRegion) {
        this.exposeNativeRegion = exposeNativeRegion;
    }

    public boolean isExposeNativeRegion() {
        return this.exposeNativeRegion;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getRegion().containsKey(key);
    }

    @Override
    public boolean containsKeyOnServer(Object key) {
        return this.getRegion().containsKeyOnServer(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.getRegion().containsValue(value);
    }

    @Override
    public boolean containsValueForKey(Object key) {
        return this.getRegion().containsValueForKey(key);
    }

    @Override
    public <K, V> void create(K key, V value) {
        try {
            this.getRegion().create(key, value);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
    }

    @Override
    public <K, V> V get(K key) {
        try {
            return (V)this.getRegion().get(key);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
    }

    @Override
    public <K, V> Map<K, V> getAll(Collection<?> keys) {
        try {
            return this.getRegion().getAll(keys);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
    }

    @Override
    public <K, V> V put(K key, V value) {
        try {
            return (V)this.getRegion().put(key, value);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
    }

    @Override
    public <K, V> void putAll(Map<? extends K, ? extends V> map) {
        try {
            this.getRegion().putAll(map);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
    }

    @Override
    public <K, V> V putIfAbsent(K key, V value) {
        try {
            return (V)this.getRegion().putIfAbsent(key, value);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
    }

    @Override
    public <K, V> V remove(K key) {
        try {
            return (V)this.getRegion().remove(key);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
    }

    @Override
    public <K, V> V replace(K key, V value) {
        try {
            return (V)this.getRegion().replace(key, value);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
    }

    @Override
    public <K, V> boolean replace(K key, V oldValue, V newValue) {
        try {
            return this.getRegion().replace(key, oldValue, newValue);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
    }

    @Override
    public <E> SelectResults<E> query(String query) {
        try {
            return this.getRegion().query(query);
        }
        catch (IndexInvalidException ex) {
            throw this.convertGemFireQueryException((RuntimeException)((Object)ex));
        }
        catch (QueryInvalidException ex) {
            throw this.convertGemFireQueryException((RuntimeException)((Object)ex));
        }
        catch (GemFireCheckedException e) {
            throw this.convertGemFireAccessException(e);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
        catch (RuntimeException ex) {
            if (GemfireCacheUtils.isCqInvalidException(ex)) {
                throw GemfireCacheUtils.convertCqInvalidException(ex);
            }
            throw ex;
        }
    }

    @Override
    public <E> SelectResults<E> find(String queryString, Object ... params) throws InvalidDataAccessApiUsageException {
        try {
            QueryService queryService = this.lookupQueryService(this.getRegion());
            Query query = queryService.newQuery(queryString);
            Object result = query.execute(params);
            if (result instanceof SelectResults) {
                return (SelectResults)result;
            }
            throw new InvalidDataAccessApiUsageException("Result object returned from GemfireCallback isn't a SelectResult: [" + result + "]");
        }
        catch (IndexInvalidException ex) {
            throw this.convertGemFireQueryException((RuntimeException)((Object)ex));
        }
        catch (QueryInvalidException ex) {
            throw this.convertGemFireQueryException((RuntimeException)((Object)ex));
        }
        catch (GemFireCheckedException e) {
            throw this.convertGemFireAccessException(e);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
        catch (RuntimeException ex) {
            if (GemfireCacheUtils.isCqInvalidException(ex)) {
                throw GemfireCacheUtils.convertCqInvalidException(ex);
            }
            throw ex;
        }
    }

    @Override
    public <T> T findUnique(String queryString, Object ... params) throws InvalidDataAccessApiUsageException {
        try {
            QueryService queryService = this.lookupQueryService(this.getRegion());
            Query query = queryService.newQuery(queryString);
            Object result = query.execute(params);
            if (result instanceof SelectResults) {
                SelectResults selectResults = (SelectResults)result;
                if (selectResults.asList().size() == 1) {
                    result = selectResults.iterator().next();
                } else {
                    throw new InvalidDataAccessApiUsageException(String.format("The result returned from query (%1$s) is not unique: (%2$s).", queryString, result));
                }
            }
            return (T)result;
        }
        catch (IndexInvalidException ex) {
            throw this.convertGemFireQueryException((RuntimeException)((Object)ex));
        }
        catch (QueryInvalidException ex) {
            throw this.convertGemFireQueryException((RuntimeException)((Object)ex));
        }
        catch (GemFireCheckedException e) {
            throw this.convertGemFireAccessException(e);
        }
        catch (GemFireException e) {
            throw this.convertGemFireAccessException(e);
        }
        catch (RuntimeException ex) {
            if (GemfireCacheUtils.isCqInvalidException(ex)) {
                throw GemfireCacheUtils.convertCqInvalidException(ex);
            }
            throw ex;
        }
    }

    protected QueryService lookupQueryService(Region<?, ?> region) {
        return this.requiresLocalQueryService(region) ? ((ClientCache)region.getRegionService()).getLocalQueryService() : region.getRegionService().getQueryService();
    }

    boolean isLocalWithNoServerProxy(Region<?, ?> region) {
        return region instanceof LocalRegion && !((LocalRegion)region).hasServerProxy();
    }

    private boolean requiresLocalQueryService(Region<?, ?> region) {
        return region.getRegionService() instanceof ClientCache && this.isLocalWithNoServerProxy(region) && Scope.LOCAL.equals(region.getAttributes().getScope());
    }

    @Override
    public <T> T execute(GemfireCallback<T> action) throws DataAccessException {
        return this.execute(action, this.isExposeNativeRegion());
    }

    @Override
    public <T> T execute(GemfireCallback<T> action, boolean exposeNativeRegion) throws DataAccessException {
        Assert.notNull(action, (String)"Callback object must not be null");
        try {
            Object regionToExpose = exposeNativeRegion ? this.getRegion() : this.regionProxy;
            return action.doInGemfire((Region<?, ?>)regionToExpose);
        }
        catch (IndexInvalidException ex) {
            throw this.convertGemFireQueryException((RuntimeException)((Object)ex));
        }
        catch (QueryInvalidException ex) {
            throw this.convertGemFireQueryException((RuntimeException)((Object)ex));
        }
        catch (GemFireCheckedException ex) {
            throw this.convertGemFireAccessException(ex);
        }
        catch (GemFireException ex) {
            throw this.convertGemFireAccessException(ex);
        }
        catch (RuntimeException ex) {
            if (GemfireCacheUtils.isCqInvalidException(ex)) {
                throw GemfireCacheUtils.convertCqInvalidException(ex);
            }
            throw ex;
        }
    }

    protected <K, V> Region<K, V> createRegionProxy(Region<K, V> region) {
        return (Region)Proxy.newProxyInstance(region.getClass().getClassLoader(), ClassUtils.getAllInterfacesForClass(region.getClass(), (ClassLoader)this.getClass().getClassLoader()), (InvocationHandler)new RegionCloseSuppressingInvocationHandler(region));
    }

    private static class RegionCloseSuppressingInvocationHandler
    implements InvocationHandler {
        private final Region<?, ?> target;

        public RegionCloseSuppressingInvocationHandler(Region<?, ?> target) {
            Assert.notNull(target, (String)"The Region to target must not be null.");
            this.target = target;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.getName().equals("equals")) {
                return proxy == args[0];
            }
            if (method.getName().equals("hashCode")) {
                return System.identityHashCode(proxy);
            }
            if (method.getName().equals("close")) {
                return null;
            }
            try {
                return method.invoke(this.target, args);
            }
            catch (InvocationTargetException ex) {
                throw ex.getTargetException();
            }
        }
    }
}

