/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.wan;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.management.internal.cli.util.spring.StringUtils;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public abstract class AbstractWANComponentFactoryBean<T>
implements BeanNameAware,
FactoryBean<T>,
InitializingBean,
DisposableBean {
    protected static final List<String> VALID_ORDER_POLICIES = Arrays.asList("KEY", "PARTITION", "THREAD");
    protected Log log = LogFactory.getLog(this.getClass());
    protected final Cache cache;
    protected Object factory;
    private String beanName;
    private String name;

    protected AbstractWANComponentFactoryBean(Cache cache) {
        this.cache = cache;
    }

    public final void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setFactory(Object factory) {
        this.factory = factory;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return StringUtils.hasText((String)this.name) ? this.name : this.beanName;
    }

    public abstract T getObject() throws Exception;

    public abstract Class<?> getObjectType();

    public final boolean isSingleton() {
        return true;
    }

    public final void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.getName(), (String)"Name must not be null.");
        Assert.notNull((Object)this.cache, (String)"Cache must not be null.");
        this.doInit();
    }

    protected abstract void doInit() throws Exception;

    public void destroy() throws Exception {
    }
}

