/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionService;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.CollectionUtils;

public class FunctionServiceFactoryBean
implements FactoryBean<FunctionService>,
InitializingBean {
    private static FunctionService functionService;
    private static Log logger;
    private List<Function> functions;

    public void afterPropertiesSet() throws Exception {
        if (!CollectionUtils.isEmpty(this.functions)) {
            for (Function function : this.functions) {
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("registering function with ID: " + function.getId()));
                }
                FunctionService.registerFunction((Function)function);
            }
        }
    }

    public void setFunctions(List<Function> functions) {
        this.functions = functions;
    }

    public FunctionService getObject() throws Exception {
        return functionService;
    }

    public Class<?> getObjectType() {
        return FunctionService.class;
    }

    public boolean isSingleton() {
        return true;
    }

    static {
        logger = LogFactory.getLog(FunctionServiceFactoryBean.class);
    }
}

