/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config;

import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.RegionAttributesFactoryBean;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.client.Interest;
import org.springframework.data.gemfire.client.RegexInterest;
import org.springframework.data.gemfire.config.AbstractRegionParser;
import org.springframework.data.gemfire.config.ParsingUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class ClientRegionParser
extends AbstractRegionParser {
    ClientRegionParser() {
    }

    @Override
    protected Class<?> getRegionFactoryClass() {
        return ClientRegionFactoryBean.class;
    }

    @Override
    protected void doParseRegion(Element element, ParserContext parserContext, BeanDefinitionBuilder regionBuilder, boolean subRegion) {
        this.validateDataPolicyShortcutAttributesMutualExclusion(element, parserContext);
        String resolvedCacheRef = ParsingUtils.resolveCacheReference(element.getAttribute("cache-ref"));
        if (!subRegion) {
            regionBuilder.addPropertyReference("cache", resolvedCacheRef);
            ParsingUtils.setPropertyValue(element, regionBuilder, "close");
            ParsingUtils.setPropertyValue(element, regionBuilder, "destroy");
        }
        ParsingUtils.setPropertyValue(element, regionBuilder, "name");
        ParsingUtils.setPropertyValue(element, regionBuilder, "data-policy", "dataPolicyName");
        ParsingUtils.setPropertyValue(element, regionBuilder, "ignore-if-exists", "lookupEnabled");
        ParsingUtils.setPropertyValue(element, regionBuilder, "persistent");
        ParsingUtils.setPropertyValue(element, regionBuilder, "pool-name");
        ParsingUtils.setPropertyValue(element, regionBuilder, "shortcut");
        this.parseDiskStoreAttribute(element, regionBuilder);
        BeanDefinitionBuilder regionAttributesBuilder = BeanDefinitionBuilder.genericBeanDefinition(RegionAttributesFactoryBean.class);
        this.mergeTemplateRegionAttributes(element, parserContext, regionBuilder, regionAttributesBuilder);
        ParsingUtils.parseOptionalRegionAttributes(parserContext, element, regionAttributesBuilder);
        ParsingUtils.parseStatistics(element, regionAttributesBuilder);
        ParsingUtils.parseExpiration(parserContext, element, regionAttributesBuilder);
        ParsingUtils.parseEviction(parserContext, element, regionAttributesBuilder);
        ParsingUtils.parseCompressor(parserContext, element, regionAttributesBuilder);
        regionBuilder.addPropertyValue("attributes", (Object)regionAttributesBuilder.getBeanDefinition());
        List subElements = DomUtils.getChildElements((Element)element);
        ManagedList interests = new ManagedList();
        for (Element subElement : subElements) {
            String subElementLocalName = subElement.getLocalName();
            if ("cache-listener".equals(subElementLocalName)) {
                regionBuilder.addPropertyValue("cacheListeners", ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, regionBuilder));
                continue;
            }
            if ("cache-loader".equals(subElementLocalName)) {
                regionBuilder.addPropertyValue("cacheLoader", ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, regionBuilder));
                continue;
            }
            if ("cache-writer".equals(subElementLocalName)) {
                regionBuilder.addPropertyValue("cacheWriter", ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, subElement, regionBuilder));
                continue;
            }
            if ("key-interest".equals(subElementLocalName)) {
                interests.add(this.parseKeyInterest(subElement, parserContext));
                continue;
            }
            if (!"regex-interest".equals(subElementLocalName)) continue;
            interests.add(this.parseRegexInterest(subElement));
        }
        if (!interests.isEmpty()) {
            regionBuilder.addPropertyValue("interests", (Object)interests);
        }
        if (!subRegion) {
            this.parseSubRegions(element, parserContext, resolvedCacheRef);
        }
    }

    private void parseDiskStoreAttribute(Element element, BeanDefinitionBuilder builder) {
        String diskStoreRefAttribute = element.getAttribute("disk-store-ref");
        if (StringUtils.hasText((String)diskStoreRefAttribute)) {
            builder.addPropertyValue("diskStoreName", (Object)diskStoreRefAttribute);
            builder.addDependsOn(diskStoreRefAttribute);
        }
    }

    private void parseCommonInterestAttributes(Element element, BeanDefinitionBuilder builder) {
        ParsingUtils.setPropertyValue(element, builder, "durable", "durable");
        ParsingUtils.setPropertyValue(element, builder, "result-policy", "policy");
        ParsingUtils.setPropertyValue(element, builder, "receive-values", "receiveValues");
    }

    private Object parseKeyInterest(Element keyInterestElement, ParserContext parserContext) {
        BeanDefinitionBuilder keyInterestBuilder = BeanDefinitionBuilder.genericBeanDefinition(Interest.class);
        this.parseCommonInterestAttributes(keyInterestElement, keyInterestBuilder);
        keyInterestBuilder.addConstructorArgValue(ParsingUtils.parseRefOrNestedBeanDeclaration(parserContext, keyInterestElement, keyInterestBuilder, "key-ref"));
        return keyInterestBuilder.getBeanDefinition();
    }

    private Object parseRegexInterest(Element regexInterestElement) {
        BeanDefinitionBuilder regexInterestBuilder = BeanDefinitionBuilder.genericBeanDefinition(RegexInterest.class);
        this.parseCommonInterestAttributes(regexInterestElement, regexInterestBuilder);
        ParsingUtils.setPropertyValue(regexInterestElement, regexInterestBuilder, "pattern", "key");
        return regexInterestBuilder.getBeanDefinition();
    }
}

