/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.listener;

import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.listener.ContinuousQueryListener;
import org.springframework.util.Assert;

public class ContinuousQueryDefinition
implements InitializingBean {
    private boolean durable = false;
    private ContinuousQueryListener listener;
    private String name;
    private String query;

    public ContinuousQueryDefinition() {
    }

    public ContinuousQueryDefinition(String query, ContinuousQueryListener listener) {
        this(query, listener, false);
    }

    public ContinuousQueryDefinition(String query, ContinuousQueryListener listener, boolean durable) {
        this.query = query;
        this.listener = listener;
        this.durable = durable;
        this.afterPropertiesSet();
    }

    public ContinuousQueryDefinition(String name, String query, ContinuousQueryListener listener) {
        this(name, query, listener, false);
    }

    public ContinuousQueryDefinition(String name, String query, ContinuousQueryListener listener, boolean durable) {
        this.name = name;
        this.query = query;
        this.listener = listener;
        this.durable = durable;
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() {
        Assert.hasText((String)this.query, (String)"A non-empty query is required.");
        Assert.notNull((Object)this.listener, (String)"A non-null listener is required.");
    }

    public boolean isDurable() {
        return this.durable;
    }

    public String getName() {
        return this.name;
    }

    public String getQuery() {
        return this.query;
    }

    public ContinuousQueryListener getListener() {
        return this.listener;
    }
}

