/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.client;

import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.client.PoolManager;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.pdx.PdxSerializer;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.data.gemfire.CacheFactoryBean;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class ClientCacheFactoryBean
extends CacheFactoryBean {
    protected Boolean readyForEvents = false;
    private Pool pool;
    private String poolName;

    @Override
    protected void postProcessPropertiesBeforeInitialization(Properties gemfireProperties) {
    }

    @Override
    protected <T extends GemFireCache> T fetchCache() {
        return (T)ClientCacheFactory.getAnyInstance();
    }

    @Override
    protected Properties resolveProperties() {
        Properties gemfireProperties = super.resolveProperties();
        Object distributedSystem = this.getDistributedSystem();
        if (GemfireUtils.isConnected(distributedSystem)) {
            Properties distributedSystemProperties = (Properties)distributedSystem.getProperties().clone();
            distributedSystemProperties.putAll((Map<?, ?>)gemfireProperties);
            gemfireProperties = distributedSystemProperties;
        }
        return gemfireProperties;
    }

    <T extends DistributedSystem> T getDistributedSystem() {
        return GemfireUtils.getDistributedSystem();
    }

    @Override
    protected Object createFactory(Properties gemfireProperties) {
        return new ClientCacheFactory(gemfireProperties);
    }

    @Override
    protected Object prepareFactory(Object factory) {
        if (this.isPdxOptionsSpecified()) {
            ClientCacheFactory clientCacheFactory = (ClientCacheFactory)factory;
            if (this.pdxSerializer != null) {
                Assert.isAssignable(PdxSerializer.class, this.pdxSerializer.getClass(), (String)"Invalid pdx serializer used");
                clientCacheFactory.setPdxSerializer((PdxSerializer)this.pdxSerializer);
            }
            if (this.pdxDiskStoreName != null) {
                clientCacheFactory.setPdxDiskStore(this.pdxDiskStoreName);
            }
            if (this.pdxIgnoreUnreadFields != null) {
                clientCacheFactory.setPdxIgnoreUnreadFields(this.pdxIgnoreUnreadFields.booleanValue());
            }
            if (this.pdxPersistent != null) {
                clientCacheFactory.setPdxPersistent(this.pdxPersistent.booleanValue());
            }
            if (this.pdxReadSerialized != null) {
                clientCacheFactory.setPdxReadSerialized(this.pdxReadSerialized.booleanValue());
            }
        }
        return factory;
    }

    @Override
    protected <T extends GemFireCache> T createCache(Object factory) {
        return (T)this.initializePool((ClientCacheFactory)factory).create();
    }

    private ClientCacheFactory initializePool(ClientCacheFactory clientCacheFactory) {
        this.resolvePool(this.pool);
        return clientCacheFactory;
    }

    private Pool resolvePool(Pool pool) {
        Pool localPool = pool;
        if (localPool == null && (localPool = PoolManager.find((String)this.poolName)) == null) {
            try {
                if (StringUtils.hasText((String)this.poolName) && this.getBeanFactory().isTypeMatch(this.poolName, Pool.class)) {
                    localPool = (Pool)this.getBeanFactory().getBean(this.poolName, Pool.class);
                } else {
                    localPool = (Pool)this.getBeanFactory().getBean(Pool.class);
                    this.poolName = localPool.getName();
                }
            }
            catch (Exception e) {
                throw new BeanInitializationException(String.format("no bean of type '%1$s' having name '%2$s' was found%3$s", Pool.class.getName(), this.poolName, "DEFAULT".equals(this.poolName) ? "; a ClientCache requires a Pool" : ""), (Throwable)e);
            }
        }
        return localPool;
    }

    @Override
    protected <T extends GemFireCache> T postProcess(T cache) throws IOException {
        return this.readyForEvents(super.postProcess(cache));
    }

    private <T extends GemFireCache> T readyForEvents(T clientCache) {
        if (Boolean.TRUE.equals(this.getReadyForEvents()) && !clientCache.isClosed()) {
            try {
                ((ClientCache)clientCache).readyForEvents();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return clientCache;
    }

    @Override
    public final void setEnableAutoReconnect(Boolean enableAutoReconnect) {
        throw new UnsupportedOperationException("Auto-reconnect is not supported on ClientCache.");
    }

    @Override
    public final Boolean getEnableAutoReconnect() {
        return Boolean.FALSE;
    }

    public void setPool(Pool pool) {
        Assert.notNull((Object)pool, (String)"The GemFire Pool must not be null!");
        this.pool = pool;
    }

    public void setPoolName(String poolName) {
        Assert.hasText((String)poolName, (String)"The Pool 'name' is required!");
        this.poolName = poolName;
    }

    public void setReadyForEvents(Boolean readyForEvents) {
        this.readyForEvents = readyForEvents;
    }

    public Boolean getReadyForEvents() {
        return this.readyForEvents;
    }

    @Override
    public final Boolean getUseClusterConfiguration() {
        return Boolean.FALSE;
    }

    @Override
    public final void setUseClusterConfiguration(Boolean useClusterConfiguration) {
        throw new UnsupportedOperationException("Shared, cluster configuration is not applicable to clients.");
    }
}

