/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.mapping;

import com.gemstone.gemfire.pdx.PdxReader;
import com.gemstone.gemfire.pdx.PdxSerializer;
import com.gemstone.gemfire.pdx.PdxWriter;
import java.util.Collections;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.gemfire.mapping.GemfireMappingContext;
import org.springframework.data.gemfire.mapping.GemfirePersistentEntity;
import org.springframework.data.gemfire.mapping.GemfirePersistentProperty;
import org.springframework.data.gemfire.mapping.GemfirePropertyValueProvider;
import org.springframework.data.gemfire.mapping.PdxReaderPropertyAccessor;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.mapping.model.MappingException;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.mapping.model.SpELContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.util.Assert;

public class MappingPdxSerializer
implements PdxSerializer,
ApplicationContextAware {
    private final ConversionService conversionService;
    private EntityInstantiators instantiators;
    private final GemfireMappingContext mappingContext;
    private Map<Class<?>, PdxSerializer> customSerializers;
    private SpELContext context;

    public MappingPdxSerializer(GemfireMappingContext mappingContext, ConversionService conversionService) {
        Assert.notNull((Object)((Object)mappingContext));
        Assert.notNull((Object)conversionService);
        this.mappingContext = mappingContext;
        this.conversionService = conversionService;
        this.instantiators = new EntityInstantiators();
        this.customSerializers = Collections.emptyMap();
        this.context = new SpELContext((PropertyAccessor)PdxReaderPropertyAccessor.INSTANCE);
    }

    public MappingPdxSerializer() {
        this(new GemfireMappingContext(), (ConversionService)new DefaultConversionService());
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = new SpELContext(this.context, (BeanFactory)applicationContext);
    }

    protected ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setCustomSerializers(Map<Class<?>, PdxSerializer> customSerializers) {
        Assert.notNull(customSerializers);
        this.customSerializers = customSerializers;
    }

    protected Map<Class<?>, PdxSerializer> getCustomSerializers() {
        return Collections.unmodifiableMap(this.customSerializers);
    }

    public void setGemfireInstantiators(Map<Class<?>, EntityInstantiator> gemfireInstantiators) {
        Assert.notNull(gemfireInstantiators);
        this.instantiators = new EntityInstantiators(gemfireInstantiators);
    }

    protected EntityInstantiators getGemfireInstantiators() {
        return this.instantiators;
    }

    protected GemfireMappingContext getMappingContext() {
        return this.mappingContext;
    }

    public Object fromData(Class<?> type, final PdxReader reader) {
        final GemfirePersistentEntity<?> entity = this.getPersistentEntity(type);
        Object instance = this.getInstantiatorFor((PersistentEntity)entity).createInstance(entity, (ParameterValueProvider)new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)new GemfirePropertyValueProvider(reader), null));
        final BeanWrapper wrapper = BeanWrapper.create((Object)instance, (ConversionService)this.getConversionService());
        entity.doWithProperties((PropertyHandler)new PropertyHandler<GemfirePersistentProperty>(){

            public void doWithPersistentProperty(GemfirePersistentProperty persistentProperty) {
                if (entity.isConstructorArgument((PersistentProperty)persistentProperty)) {
                    return;
                }
                PdxSerializer customSerializer = MappingPdxSerializer.this.getCustomSerializer(persistentProperty.getType());
                Object value = customSerializer != null ? customSerializer.fromData(persistentProperty.getType(), reader) : reader.readField(persistentProperty.getName());
                try {
                    wrapper.setProperty((PersistentProperty)persistentProperty, value);
                }
                catch (Exception e) {
                    throw new MappingException("Could not read value " + value.toString(), (Throwable)e);
                }
            }
        });
        return wrapper.getBean();
    }

    public boolean toData(Object value, final PdxWriter writer) {
        GemfirePersistentEntity<?> entity = this.getPersistentEntity(value.getClass());
        final BeanWrapper wrapper = BeanWrapper.create((Object)value, (ConversionService)this.getConversionService());
        entity.doWithProperties((PropertyHandler)new PropertyHandler<GemfirePersistentProperty>(){

            public void doWithPersistentProperty(GemfirePersistentProperty persistentProperty) {
                try {
                    Object propertyValue = wrapper.getProperty((PersistentProperty)persistentProperty);
                    PdxSerializer customSerializer = MappingPdxSerializer.this.getCustomSerializer(persistentProperty.getType());
                    if (customSerializer != null) {
                        customSerializer.toData(propertyValue, writer);
                    } else {
                        writer.writeField(persistentProperty.getName(), propertyValue, persistentProperty.getType());
                    }
                }
                catch (Exception e) {
                    throw new MappingException(String.format("Could not write value for property %1$s", new Object[]{persistentProperty}), (Throwable)e);
                }
            }
        });
        GemfirePersistentProperty idProperty = (GemfirePersistentProperty)entity.getIdProperty();
        if (idProperty != null) {
            writer.markIdentityField(idProperty.getName());
        }
        return true;
    }

    protected PdxSerializer getCustomSerializer(Class<?> type) {
        return this.getCustomSerializers().get(type);
    }

    protected EntityInstantiator getInstantiatorFor(PersistentEntity entity) {
        return this.getGemfireInstantiators().getInstantiatorFor(entity);
    }

    protected GemfirePersistentEntity<?> getPersistentEntity(Class<?> entityType) {
        return (GemfirePersistentEntity)this.getMappingContext().getPersistentEntity(entityType);
    }
}

