/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;

public abstract class CollectionUtils
extends org.springframework.util.CollectionUtils {
    public static <T> Iterable<T> iterable(final Enumeration<T> enumeration) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return org.springframework.util.CollectionUtils.toIterator((Enumeration)enumeration);
            }
        };
    }

    public static <T> Iterable<T> iterable(final Iterator<T> iterator) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return iterator;
            }
        };
    }

    public static <T> Collection<T> nullSafeCollection(Collection<T> collection) {
        return collection != null ? collection : Collections.emptyList();
    }

    public static <T> Iterable<T> nullSafeIterable(Iterable<T> iterable) {
        return iterable != null ? iterable : new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return false;
                    }

                    @Override
                    public T next() {
                        throw new NoSuchElementException("no elements in this Iterator");
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("operation not supported");
                    }
                };
            }
        };
    }
}

