/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Map;
import java.util.Properties;
import org.springframework.data.gemfire.config.annotation.EnableHttpService;
import org.springframework.data.gemfire.config.annotation.support.EmbeddedServiceConfigurationSupport;
import org.springframework.data.gemfire.util.PropertiesBuilder;

public class HttpServiceConfiguration
extends EmbeddedServiceConfigurationSupport {
    public static final boolean DEFAULT_HTTP_SERVICE_SSL_REQUIRE_AUTHENTICATION = false;
    public static final boolean DEFAULT_HTTP_SERVICE_START_DEVELOPER_REST_API = false;
    public static final int DEFAULT_HTTP_SERVICE_PORT = 7070;

    @Override
    protected Class getAnnotationType() {
        return EnableHttpService.class;
    }

    @Override
    protected Properties toGemFireProperties(Map<String, Object> annotationAttributes) {
        PropertiesBuilder gemfireProperties = PropertiesBuilder.create();
        gemfireProperties.setProperty("http-service-bind-address", annotationAttributes.get("bindAddress"));
        gemfireProperties.setPropertyIfNotDefault("http-service-port", annotationAttributes.get("port"), 7070);
        gemfireProperties.setPropertyIfNotDefault("http-service-ssl-require-authentication", annotationAttributes.get("sslRequireAuthentication"), false);
        gemfireProperties.setPropertyIfNotDefault("start-dev-rest-api", annotationAttributes.get("startDeveloperRestApi"), false);
        return gemfireProperties.build();
    }
}

