/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.TimeoutException;
import java.util.concurrent.Callable;
import org.springframework.util.Assert;

public class CallableCacheLoaderAdapter<K, V>
implements Callable<V>,
CacheLoader<K, V> {
    private final K key;
    private final CacheLoader<K, V> cacheLoader;
    private final Object argument;
    private final Region<K, V> region;

    public CallableCacheLoaderAdapter(CacheLoader<K, V> delegate) {
        this(delegate, null, null, null);
    }

    public CallableCacheLoaderAdapter(CacheLoader<K, V> delegate, K key, Region<K, V> region) {
        this(delegate, key, region, null);
    }

    public CallableCacheLoaderAdapter(CacheLoader<K, V> delegate, K key, Region<K, V> region, Object argument) {
        Assert.notNull(delegate, (String)"CacheLoader must not be null");
        this.cacheLoader = delegate;
        this.argument = argument;
        this.key = key;
        this.region = region;
    }

    protected Object getArgument() {
        return this.argument;
    }

    protected CacheLoader<K, V> getCacheLoader() {
        return this.cacheLoader;
    }

    protected K getKey() {
        return this.key;
    }

    protected Region<K, V> getRegion() {
        return this.region;
    }

    @Override
    public final V call() throws Exception {
        Assert.state((this.getKey() != null ? 1 : 0) != 0, (String)"The key for which the value is loaded for cannot be null");
        Assert.state((this.getRegion() != null ? 1 : 0) != 0, (String)"The Region to load cannot be null");
        return this.load(new LoaderHelper<K, V>(){

            public V netSearch(boolean doNetLoad) throws CacheLoaderException, TimeoutException {
                throw new UnsupportedOperationException("not implemented");
            }

            public K getKey() {
                return CallableCacheLoaderAdapter.this.getKey();
            }

            public Region<K, V> getRegion() {
                return CallableCacheLoaderAdapter.this.getRegion();
            }

            public Object getArgument() {
                return CallableCacheLoaderAdapter.this.getArgument();
            }
        });
    }

    public void close() {
        this.getCacheLoader().close();
    }

    public V load(LoaderHelper<K, V> loaderHelper) throws CacheLoaderException {
        return (V)this.getCacheLoader().load(loaderHelper);
    }
}

