/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation;

import java.util.Map;
import java.util.Properties;
import org.springframework.data.gemfire.config.annotation.EnableManager;
import org.springframework.data.gemfire.config.annotation.support.EmbeddedServiceConfigurationSupport;
import org.springframework.data.gemfire.util.PropertiesBuilder;

public class ManagerConfiguration
extends EmbeddedServiceConfigurationSupport {
    protected static final int DEFAULT_JMX_MANAGER_PORT = 1099;

    @Override
    protected Class getAnnotationType() {
        return EnableManager.class;
    }

    @Override
    protected Properties toGemFireProperties(Map<String, Object> annotationAttributes) {
        PropertiesBuilder gemfireProperties = new PropertiesBuilder();
        gemfireProperties.setProperty("jmx-manager", Boolean.TRUE.toString());
        gemfireProperties.setProperty("jmx-manager-access-file", annotationAttributes.get("accessFile"));
        gemfireProperties.setProperty("jmx-manager-bind-address", annotationAttributes.get("bindAddress"));
        gemfireProperties.setProperty("jmx-manager-hostname-for-clients", annotationAttributes.get("hostnameForClients"));
        gemfireProperties.setProperty("jmx-manager-password-file", annotationAttributes.get("passwordFile"));
        gemfireProperties.setProperty("jmx-manager-port", this.resolvePort((Integer)annotationAttributes.get("port"), 1099));
        gemfireProperties.setProperty("jmx-manager-start", annotationAttributes.get("start"));
        gemfireProperties.setProperty("jmx-manager-update-rate", annotationAttributes.get("updateRate"));
        return gemfireProperties.build();
    }
}

