/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.xml;

import java.util.Collections;
import org.springframework.aop.config.AopNamespaceUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.gemfire.config.xml.ParsingUtils;
import org.springframework.data.gemfire.support.JSONRegionAdvice;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

class GemfireRegionAutoProxyParser
implements BeanDefinitionParser {
    GemfireRegionAutoProxyParser() {
    }

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        AopNamespaceUtils.registerAspectJAnnotationAutoProxyCreatorIfNecessary((ParserContext)parserContext, (Element)element);
        BeanDefinitionBuilder jsonRegionAdviceBuilder = BeanDefinitionBuilder.rootBeanDefinition(JSONRegionAdvice.class).setRole(2);
        ParsingUtils.setPropertyValue(element, jsonRegionAdviceBuilder, "pretty-print");
        ParsingUtils.setPropertyValue(element, jsonRegionAdviceBuilder, "convert-returned-collections");
        String regionNames = element.getAttribute("included-regions");
        if (StringUtils.hasText((String)regionNames)) {
            String[] regions = StringUtils.commaDelimitedListToStringArray((String)regionNames);
            ManagedList regionList = new ManagedList(regions.length);
            Collections.addAll(regionList, regions);
            jsonRegionAdviceBuilder.addPropertyValue("includedRegions", (Object)regionList);
        }
        BeanDefinitionReaderUtils.registerWithGeneratedName((AbstractBeanDefinition)jsonRegionAdviceBuilder.getBeanDefinition(), (BeanDefinitionRegistry)parserContext.getRegistry());
        return jsonRegionAdviceBuilder.getBeanDefinition();
    }
}

