/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.function.config;

import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.data.gemfire.function.config.AbstractFunctionExecutionBeanDefinitionBuilder;
import org.springframework.data.gemfire.function.config.FunctionExecutionConfiguration;
import org.springframework.data.gemfire.function.execution.GemfireFunctionProxyFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

abstract class ServerBasedExecutionBeanDefinitionBuilder
extends AbstractFunctionExecutionBeanDefinitionBuilder {
    ServerBasedExecutionBeanDefinitionBuilder(FunctionExecutionConfiguration configuration) {
        super(configuration);
    }

    @Override
    protected BeanDefinitionBuilder getGemfireFunctionOperationsBeanDefinitionBuilder(BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder functionTemplateBuilder = BeanDefinitionBuilder.genericBeanDefinition(this.getGemfireFunctionOperationsClass());
        String cache = (String)this.configuration.getAttribute("cache");
        String pool = (String)this.configuration.getAttribute("pool");
        Assert.state((!StringUtils.hasText((String)cache) || !StringUtils.hasText((String)pool) ? 1 : 0) != 0, (String)String.format("invalid configuration for interface %s; cannot specify both 'pool' and 'cache'", this.configuration.getFunctionExecutionInterface().getName()));
        functionTemplateBuilder.addConstructorArgReference(StringUtils.hasText((String)pool) ? pool : (StringUtils.hasText((String)cache) ? cache : "gemfireCache"));
        return functionTemplateBuilder;
    }

    @Override
    protected Class<?> getFunctionProxyFactoryBeanClass() {
        return GemfireFunctionProxyFactoryBean.class;
    }

    protected abstract Class<?> getGemfireFunctionOperationsClass();
}

