/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.util;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.client.ClientCache;
import com.gemstone.gemfire.cache.client.ClientCacheFactory;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import org.springframework.data.gemfire.util.DistributedSystemUtils;
import org.springframework.util.StringUtils;

public abstract class CacheUtils
extends DistributedSystemUtils {
    public static final String DEFAULT_POOL_NAME = "DEFAULT";

    public static boolean isClient(GemFireCache cache) {
        boolean client = cache instanceof ClientCache;
        if (cache instanceof GemFireCacheImpl) {
            client &= ((GemFireCacheImpl)cache).isClient();
        }
        return client;
    }

    public static boolean isDurable(ClientCache clientCache) {
        Object distributedSystem = CacheUtils.getDistributedSystem((GemFireCache)clientCache);
        return CacheUtils.isConnected(distributedSystem) && StringUtils.hasText((String)distributedSystem.getProperties().getProperty("durable-client-id", null));
    }

    public static boolean isPeer(GemFireCache cache) {
        boolean peer = cache instanceof Cache;
        if (cache instanceof GemFireCacheImpl) {
            peer &= !((GemFireCacheImpl)cache).isClient();
        }
        return peer;
    }

    public static boolean closeCache() {
        try {
            CacheFactory.getAnyInstance().close();
            return true;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public static boolean closeClientCache() {
        try {
            ClientCacheFactory.getAnyInstance().close();
            return true;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public static Cache getCache() {
        try {
            return CacheFactory.getAnyInstance();
        }
        catch (CacheClosedException ignore) {
            return null;
        }
    }

    public static ClientCache getClientCache() {
        try {
            return ClientCacheFactory.getAnyInstance();
        }
        catch (CacheClosedException ignore) {
            return null;
        }
        catch (IllegalStateException ignore) {
            return null;
        }
    }

    public static GemFireCache resolveGemFireCache() {
        ClientCache resolvedGemFireCache = CacheUtils.getClientCache();
        return resolvedGemFireCache != null ? resolvedGemFireCache : CacheUtils.getCache();
    }

    public static String toRegionPath(String regionName) {
        return String.format("%1$s%2$s", "/", regionName);
    }
}

