/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire;

import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.RegionFactory;
import org.springframework.data.gemfire.DataPolicyConverter;
import org.springframework.data.gemfire.PeerRegionFactoryBean;
import org.springframework.data.gemfire.util.RegionUtils;
import org.springframework.util.Assert;

public class ReplicatedRegionFactoryBean<K, V>
extends PeerRegionFactoryBean<K, V> {
    @Override
    protected void resolveDataPolicy(RegionFactory<K, V> regionFactory, Boolean persistent, DataPolicy dataPolicy) {
        if (dataPolicy == null) {
            dataPolicy = this.isPersistent() ? DataPolicy.PERSISTENT_REPLICATE : DataPolicy.REPLICATE;
        } else if (DataPolicy.EMPTY.equals(dataPolicy)) {
            dataPolicy = DataPolicy.EMPTY;
        } else {
            Assert.isTrue((boolean)dataPolicy.withReplication(), (String)String.format("Data Policy '%1$s' is not supported in Replicated Regions.", dataPolicy));
        }
        RegionUtils.assertDataPolicyAndPersistentAttributeAreCompatible(dataPolicy, persistent);
        regionFactory.setDataPolicy(dataPolicy);
        this.setDataPolicy(dataPolicy);
    }

    @Override
    protected void resolveDataPolicy(RegionFactory<K, V> regionFactory, Boolean persistent, String dataPolicy) {
        DataPolicy resolvedDataPolicy = null;
        if (dataPolicy != null) {
            resolvedDataPolicy = new DataPolicyConverter().convert(dataPolicy);
            Assert.notNull((Object)resolvedDataPolicy, (String)String.format("Data Policy '%1$s' is invalid.", dataPolicy));
        }
        this.resolveDataPolicy(regionFactory, persistent, resolvedDataPolicy);
    }
}

