/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.xml;

import java.util.List;
import org.apache.geode.cache.LossAction;
import org.apache.geode.cache.MembershipAttributes;
import org.apache.geode.cache.ResumptionAction;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.SubscriptionAttributesFactoryBean;
import org.springframework.data.gemfire.config.support.GemfireFeature;
import org.springframework.data.gemfire.eviction.EvictionAttributesFactoryBean;
import org.springframework.data.gemfire.expiration.ExpirationAttributesFactoryBean;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

abstract class ParsingUtils {
    protected static final String CACHE_PROPERTY_NAME = "cache";
    protected static final String REGION_PROPERTY_NAME = "region";
    protected static final String CACHE_REF_ATTRIBUTE_NAME = "cache-ref";
    protected static final String REGION_REF_ATTRIBUTE_NAME = "region-ref";

    ParsingUtils() {
    }

    static void setPropertyReference(Element element, BeanDefinitionBuilder builder, String attributeName, String propertyName) {
        String attributeValue = element.getAttribute(attributeName);
        if (StringUtils.hasText((String)attributeValue)) {
            builder.addPropertyReference(propertyName, attributeValue);
        }
    }

    static void setPropertyReference(Element element, BeanDefinitionBuilder builder, String attributeName) {
        ParsingUtils.setPropertyReference(element, builder, attributeName, Conventions.attributeNameToPropertyName((String)attributeName));
    }

    static void setPropertyValue(Element element, BeanDefinitionBuilder builder, String attributeName, String propertyName, Object defaultValue) {
        String attributeValue = element.getAttribute(attributeName);
        if (StringUtils.hasText((String)attributeValue)) {
            builder.addPropertyValue(propertyName, (Object)attributeValue);
        } else if (defaultValue != null) {
            builder.addPropertyValue(propertyName, defaultValue);
        }
    }

    static void setPropertyValue(Element element, BeanDefinitionBuilder builder, String attributeName, String propertyName) {
        ParsingUtils.setPropertyValue(element, builder, attributeName, propertyName, null);
    }

    static void setPropertyValue(Element element, BeanDefinitionBuilder builder, String attributeName) {
        ParsingUtils.setPropertyValue(element, builder, attributeName, Conventions.attributeNameToPropertyName((String)attributeName));
    }

    static void setPropertyValue(BeanDefinitionBuilder builder, BeanDefinition source, String propertyName, boolean withDependsOn) {
        PropertyValue propertyValue = source.getPropertyValues().getPropertyValue(propertyName);
        if (propertyValue != null) {
            builder.addPropertyValue(propertyValue.getName(), propertyValue.getValue());
            if (withDependsOn && propertyValue.getValue() instanceof RuntimeBeanReference) {
                builder.addDependsOn(((RuntimeBeanReference)propertyValue.getValue()).getBeanName());
            }
        }
    }

    static void setPropertyValue(BeanDefinitionBuilder builder, BeanDefinition source, String propertyName) {
        ParsingUtils.setPropertyValue(builder, source, propertyName, false);
    }

    static Object getBeanReference(Element element, ParserContext parserContext, String refAttributeName) {
        String refAttributeValue = element.getAttribute(refAttributeName);
        RuntimeBeanReference returnValue = null;
        if (StringUtils.hasText((String)refAttributeValue)) {
            if (!DomUtils.getChildElements((Element)element).isEmpty()) {
                parserContext.getReaderContext().error(String.format("Use either the '%1$s' attribute or a nested bean declaration for '%2$s' element, but not both.", refAttributeName, element.getLocalName()), (Object)element);
            }
            returnValue = new RuntimeBeanReference(refAttributeValue);
        }
        return returnValue;
    }

    static Object parseRefOrNestedCustomElement(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Object beanRef = ParsingUtils.getBeanReference(element, parserContext, "bean");
        return beanRef != null ? beanRef : parserContext.getDelegate().parseCustomElement(element, (BeanDefinition)builder.getBeanDefinition());
    }

    static Object parseRefOrNestedBeanDeclaration(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        return ParsingUtils.parseRefOrNestedBeanDeclaration(element, parserContext, builder, "ref", false);
    }

    static Object parseRefOrNestedBeanDeclaration(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, String refAttributeName) {
        return ParsingUtils.parseRefOrNestedBeanDeclaration(element, parserContext, builder, refAttributeName, false);
    }

    static Object parseRefOrSingleNestedBeanDeclaration(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        return ParsingUtils.parseRefOrNestedBeanDeclaration(element, parserContext, builder, "ref", true);
    }

    static Object parseRefOrSingleNestedBeanDeclaration(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, String refAttributeName) {
        return ParsingUtils.parseRefOrNestedBeanDeclaration(element, parserContext, builder, refAttributeName, true);
    }

    static Object parseRefOrNestedBeanDeclaration(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, String refAttributeName, boolean single) {
        Object beanReference = ParsingUtils.getBeanReference(element, parserContext, refAttributeName);
        if (beanReference != null) {
            return beanReference;
        }
        List childElements = DomUtils.getChildElements((Element)element);
        if (childElements.size() == 1) {
            return parserContext.getDelegate().parsePropertySubElement((Element)childElements.get(0), (BeanDefinition)builder.getRawBeanDefinition());
        }
        if (single) {
            parserContext.getReaderContext().error(String.format("The element '%1$s' does not support multiple nested bean definitions.", element.getLocalName()), (Object)element);
        }
        ManagedList list = new ManagedList();
        for (Element childElement : childElements) {
            list.add(parserContext.getDelegate().parsePropertySubElement(childElement, (BeanDefinition)builder.getRawBeanDefinition()));
        }
        return list;
    }

    static boolean parseEviction(Element element, ParserContext parserContext, BeanDefinitionBuilder regionAttributesBuilder) {
        Element evictionElement = DomUtils.getChildElementByTagName((Element)element, (String)"eviction");
        if (evictionElement != null) {
            BeanDefinitionBuilder evictionAttributesBuilder = BeanDefinitionBuilder.genericBeanDefinition(EvictionAttributesFactoryBean.class);
            ParsingUtils.setPropertyValue(evictionElement, evictionAttributesBuilder, "action");
            ParsingUtils.setPropertyValue(evictionElement, evictionAttributesBuilder, "threshold");
            ParsingUtils.setPropertyValue(evictionElement, evictionAttributesBuilder, "type");
            Element objectSizerElement = DomUtils.getChildElementByTagName((Element)evictionElement, (String)"object-sizer");
            if (objectSizerElement != null) {
                Object sizer = ParsingUtils.parseRefOrNestedBeanDeclaration(objectSizerElement, parserContext, evictionAttributesBuilder);
                evictionAttributesBuilder.addPropertyValue("objectSizer", sizer);
            }
            regionAttributesBuilder.addPropertyValue("evictionAttributes", (Object)evictionAttributesBuilder.getBeanDefinition());
            return true;
        }
        return false;
    }

    static boolean parseSubscription(Element element, ParserContext parserContext, BeanDefinitionBuilder regionAttributesBuilder) {
        Element subscriptionElement = DomUtils.getChildElementByTagName((Element)element, (String)"subscription");
        if (subscriptionElement != null) {
            BeanDefinitionBuilder subscriptionAttributesBuilder = BeanDefinitionBuilder.genericBeanDefinition(SubscriptionAttributesFactoryBean.class);
            ParsingUtils.setPropertyValue(subscriptionElement, subscriptionAttributesBuilder, "type", "interestPolicy");
            regionAttributesBuilder.addPropertyValue("subscriptionAttributes", (Object)subscriptionAttributesBuilder.getBeanDefinition());
            return true;
        }
        return false;
    }

    static void parseTransportFilters(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Element transportFilterElement = DomUtils.getChildElementByTagName((Element)element, (String)"transport-filter");
        if (transportFilterElement != null) {
            builder.addPropertyValue("transportFilters", ParsingUtils.parseRefOrNestedBeanDeclaration(transportFilterElement, parserContext, builder));
        }
    }

    static void parseStatistics(Element element, BeanDefinitionBuilder regionAttributesBuilder) {
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "statistics", "statisticsEnabled");
    }

    static boolean parseExpiration(Element element, ParserContext parserContext, BeanDefinitionBuilder regionAttributesBuilder) {
        boolean result = ParsingUtils.parseExpiration(element, "region-ttl", "regionTimeToLive", regionAttributesBuilder);
        result |= ParsingUtils.parseExpiration(element, "region-tti", "regionIdleTimeout", regionAttributesBuilder);
        result |= ParsingUtils.parseExpiration(element, "entry-ttl", "entryTimeToLive", regionAttributesBuilder);
        result |= ParsingUtils.parseExpiration(element, "entry-tti", "entryIdleTimeout", regionAttributesBuilder);
        result |= ParsingUtils.parseCustomExpiration(element, parserContext, "custom-entry-ttl", "customEntryTimeToLive", regionAttributesBuilder);
        if (result |= ParsingUtils.parseCustomExpiration(element, parserContext, "custom-entry-tti", "customEntryIdleTimeout", regionAttributesBuilder)) {
            regionAttributesBuilder.addPropertyValue("statisticsEnabled", (Object)Boolean.TRUE);
        }
        return result;
    }

    static void parseOptionalRegionAttributes(Element element, ParserContext parserContext, BeanDefinitionBuilder regionAttributesBuilder) {
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "cloning-enabled");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "concurrency-level");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "disk-synchronous");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "enable-async-conflation");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "enable-subscription-conflation");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "ignore-jta", "ignoreJTA");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "index-update-type");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "initial-capacity");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "is-lock-grantor", "lockGrantor");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "key-constraint");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "load-factor");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "multicast-enabled");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "off-heap");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "publisher");
        ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "value-constraint");
        String concurrencyChecksEnabled = element.getAttribute("concurrency-checks-enabled");
        if (StringUtils.hasText((String)concurrencyChecksEnabled)) {
            ParsingUtils.setPropertyValue(element, regionAttributesBuilder, "concurrency-checks-enabled");
        }
    }

    static void parseMembershipAttributes(Element element, ParserContext parserContext, BeanDefinitionBuilder regionAttributesBuilder) {
        Element membershipAttributes = DomUtils.getChildElementByTagName((Element)element, (String)"membership-attributes");
        if (membershipAttributes != null) {
            String[] requiredRoles = StringUtils.commaDelimitedListToStringArray((String)membershipAttributes.getAttribute("required-roles"));
            String lossActionValue = membershipAttributes.getAttribute("loss-action");
            LossAction lossAction = StringUtils.hasText((String)lossActionValue) ? LossAction.fromName((String)lossActionValue.toUpperCase().replace("-", "_")) : LossAction.NO_ACCESS;
            String resumptionActionValue = membershipAttributes.getAttribute("resumption-action");
            ResumptionAction resumptionAction = StringUtils.hasText((String)resumptionActionValue) ? ResumptionAction.fromName((String)resumptionActionValue.toUpperCase().replace("-", "_")) : ResumptionAction.REINITIALIZE;
            regionAttributesBuilder.addPropertyValue("membershipAttributes", (Object)new MembershipAttributes(requiredRoles, lossAction, resumptionAction));
        }
    }

    static void parseScope(Element element, BeanDefinitionBuilder builder) {
        String scopeAttributeValue = element.getAttribute("scope");
        if (StringUtils.hasText((String)scopeAttributeValue)) {
            builder.addPropertyValue("scope", (Object)scopeAttributeValue);
        }
    }

    private static boolean parseExpiration(Element rootElement, String elementName, String propertyName, BeanDefinitionBuilder regionAttributesBuilder) {
        Element expirationElement = DomUtils.getChildElementByTagName((Element)rootElement, (String)elementName);
        if (expirationElement != null) {
            BeanDefinitionBuilder expirationAttributesBuilder = BeanDefinitionBuilder.genericBeanDefinition(ExpirationAttributesFactoryBean.class);
            ParsingUtils.setPropertyValue(expirationElement, expirationAttributesBuilder, "action");
            ParsingUtils.setPropertyValue(expirationElement, expirationAttributesBuilder, "timeout");
            regionAttributesBuilder.addPropertyValue(propertyName, (Object)expirationAttributesBuilder.getBeanDefinition());
            return true;
        }
        return false;
    }

    private static boolean parseCustomExpiration(Element rootElement, ParserContext parserContext, String elementName, String propertyName, BeanDefinitionBuilder regionAttributesBuilder) {
        Element expirationElement = DomUtils.getChildElementByTagName((Element)rootElement, (String)elementName);
        if (expirationElement != null) {
            Object customExpiry = ParsingUtils.parseRefOrSingleNestedBeanDeclaration(expirationElement, parserContext, regionAttributesBuilder);
            regionAttributesBuilder.addPropertyValue(propertyName, customExpiry);
            return true;
        }
        return false;
    }

    static void parseCompressor(Element element, ParserContext parserContext, BeanDefinitionBuilder regionAttributesBuilder) {
        Element compressorElement = DomUtils.getChildElementByTagName((Element)element, (String)"compressor");
        if (compressorElement != null) {
            regionAttributesBuilder.addPropertyValue("compressor", ParsingUtils.parseRefOrSingleNestedBeanDeclaration(compressorElement, parserContext, regionAttributesBuilder));
        }
    }

    static void assertGemFireFeatureAvailable(Element element, ParserContext parserContext) {
        if (GemfireUtils.isGemfireFeatureUnavailable(element)) {
            parserContext.getReaderContext().error(String.format("'%1$s' is not supported in %2$s v%3$s", element.getLocalName(), GemfireUtils.GEMFIRE_NAME, GemfireUtils.GEMFIRE_VERSION), (Object)element);
        }
    }

    static void setCacheReference(Element element, BeanDefinitionBuilder builder) {
        builder.addPropertyReference(CACHE_PROPERTY_NAME, ParsingUtils.resolveCacheReference(element));
    }

    static String resolveCacheReference(Element element) {
        return ParsingUtils.resolveCacheReference(element.getAttribute(CACHE_REF_ATTRIBUTE_NAME));
    }

    static String resolveCacheReference(String cacheReference) {
        return SpringUtils.defaultIfEmpty(cacheReference, "gemfireCache");
    }

    static void setRegionReference(Element element, BeanDefinitionBuilder builder) {
        builder.addPropertyReference(REGION_PROPERTY_NAME, ParsingUtils.resolveRegionReference(element));
    }

    static String resolveRegionReference(Element element) {
        return element.getAttribute(REGION_REF_ATTRIBUTE_NAME);
    }

    static void throwExceptionWhenGemFireFeatureUnavailable(GemfireFeature feature, String elementName, String attributeName, ParserContext parserContext) {
        if (GemfireUtils.isGemfireFeatureUnavailable(feature)) {
            String messagePrefix = attributeName != null ? String.format("Attribute '%1$s' of element '%2$s'", attributeName, elementName) : String.format("Element '%1$s'", elementName);
            parserContext.getReaderContext().error(String.format("%1$s requires Pivotal GemFire version 7 or later. The current version is %2$s.", messagePrefix, GemfireUtils.GEMFIRE_VERSION), null);
        }
    }
}

