/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.search.lucene;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.lucene.LuceneIndex;
import org.apache.geode.cache.lucene.LuceneIndexFactory;
import org.apache.geode.cache.lucene.LuceneSerializer;
import org.apache.geode.cache.lucene.LuceneService;
import org.apache.geode.cache.lucene.LuceneServiceProvider;
import org.apache.lucene.analysis.Analyzer;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.config.annotation.IndexConfigurer;
import org.springframework.data.gemfire.support.AbstractFactoryBeanSupport;
import org.springframework.data.gemfire.util.ArrayUtils;
import org.springframework.data.gemfire.util.CacheUtils;
import org.springframework.data.gemfire.util.SpringUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class LuceneIndexFactoryBean
extends AbstractFactoryBeanSupport<LuceneIndex>
implements DisposableBean,
InitializingBean {
    protected static final boolean DEFAULT_DESTROY = false;
    private boolean destroy = false;
    private GemFireCache gemfireCache;
    private List<IndexConfigurer> indexConfigurers = Collections.emptyList();
    private IndexConfigurer compositeIndexConfigurer = new IndexConfigurer(){

        @Override
        public void configure(String beanName, LuceneIndexFactoryBean bean) {
            org.springframework.data.gemfire.util.CollectionUtils.nullSafeCollection(LuceneIndexFactoryBean.this.indexConfigurers).forEach(indexConfigurer -> indexConfigurer.configure(beanName, bean));
        }
    };
    private List<String> fields;
    private LuceneIndex luceneIndex;
    private LuceneSerializer luceneSerializer;
    private LuceneService luceneService;
    private Map<String, Analyzer> fieldAnalyzers;
    private Region<?, ?> region;
    private String indexName;
    private String regionPath;

    public void afterPropertiesSet() throws Exception {
        String indexName = this.getIndexName();
        this.applyIndexConfigurers(indexName);
        this.gemfireCache = this.resolveCache();
        this.luceneService = this.resolveLuceneService();
        this.regionPath = this.resolveRegionPath();
        this.setLuceneIndex(this.resolveLuceneIndex(indexName, this.getRegionPath()));
    }

    private void applyIndexConfigurers(String indexName) {
        this.applyIndexConfigurers(indexName, this.getCompositeRegionConfigurer());
    }

    protected void applyIndexConfigurers(String indexName, IndexConfigurer ... indexConfigurers) {
        this.applyIndexConfigurers(indexName, Arrays.asList(ArrayUtils.nullSafeArray(indexConfigurers, IndexConfigurer.class)));
    }

    protected void applyIndexConfigurers(String indexName, Iterable<IndexConfigurer> indexConfigurers) {
        StreamSupport.stream(org.springframework.data.gemfire.util.CollectionUtils.nullSafeIterable(indexConfigurers).spliterator(), false).forEach(indexConfigurer -> indexConfigurer.configure(indexName, this));
    }

    protected LuceneIndex createLuceneIndex(String indexName, String regionPath) {
        LuceneService luceneService = this.resolveLuceneService();
        LuceneIndexFactory indexFactory = luceneService.createIndexFactory();
        Map<String, Analyzer> fieldAnalyzers = this.getFieldAnalyzers();
        if (CollectionUtils.isEmpty(fieldAnalyzers)) {
            indexFactory.setFields(this.asArray(this.resolveFields(this.getFields())));
        } else {
            indexFactory.setFields(fieldAnalyzers);
        }
        Optional.ofNullable(this.getLuceneSerializer()).ifPresent(arg_0 -> ((LuceneIndexFactory)indexFactory).setLuceneSerializer(arg_0));
        indexFactory = this.postProcess(indexFactory);
        indexFactory.create(indexName, regionPath);
        return luceneService.getIndex(indexName, regionPath);
    }

    private String[] asArray(List<String> list) {
        return list.toArray(new String[list.size()]);
    }

    protected LuceneIndexFactory postProcess(LuceneIndexFactory luceneIndexFactory) {
        return luceneIndexFactory;
    }

    protected LuceneIndex postProcess(LuceneIndex luceneIndex) {
        return luceneIndex;
    }

    protected LuceneIndex resolveLuceneIndex(String indexName, String regionPath) {
        Supplier<LuceneIndex> luceneIndexSupplier = () -> Optional.ofNullable(this.resolveLuceneService()).map(luceneService -> luceneService.getIndex(indexName, regionPath)).orElseGet(() -> this.postProcess(this.createLuceneIndex(indexName, regionPath)));
        return this.getLuceneIndex().orElseGet(luceneIndexSupplier);
    }

    public void destroy() throws Exception {
        LuceneIndex luceneIndex = this.getObject();
        if (this.isLuceneIndexDestroyable(luceneIndex)) {
            this.resolveLuceneService().destroyIndex(luceneIndex.getName(), luceneIndex.getRegionPath());
        }
    }

    protected boolean isLuceneIndexDestroyable(LuceneIndex luceneIndex) {
        return luceneIndex != null && this.isDestroy();
    }

    public LuceneIndex getObject() throws Exception {
        if (this.luceneIndex == null) {
            this.setLuceneIndex(Optional.ofNullable(this.resolveLuceneService()).map(luceneService -> luceneService.getIndex(this.getIndexName(), this.resolveRegionPath())).orElse(null));
        }
        return this.luceneIndex;
    }

    public Class<?> getObjectType() {
        return Optional.ofNullable(this.luceneIndex).map(Object::getClass).orElse(LuceneIndex.class);
    }

    protected GemFireCache resolveCache() {
        return Optional.ofNullable(this.getCache()).orElseGet(CacheUtils::resolveGemFireCache);
    }

    protected List<String> resolveFields(List<String> fields) {
        return !CollectionUtils.isEmpty(fields) ? fields : Collections.singletonList("__REGION_VALUE_FIELD");
    }

    protected LuceneIndexFactory resolveLuceneIndexFactory() {
        return this.resolveLuceneService().createIndexFactory();
    }

    protected LuceneService resolveLuceneService() {
        return Optional.ofNullable(this.getLuceneService()).orElseGet(() -> Optional.ofNullable(this.getBeanFactory()).map(it -> SpringUtils.safeGetValue(() -> (LuceneService)it.getBean(LuceneService.class), (LuceneService)null)).orElseGet(() -> this.resolveLuceneService(this.resolveCache())));
    }

    protected LuceneService resolveLuceneService(GemFireCache gemfireCache) {
        Assert.notNull((Object)gemfireCache, (String)"A reference to the GemFireCache was not properly configured");
        return LuceneServiceProvider.get((GemFireCache)gemfireCache);
    }

    protected Region<?, ?> resolveRegion() {
        return Optional.ofNullable(this.getRegion()).orElseGet(() -> {
            GemFireCache cache = this.resolveCache();
            String regionPath = this.getRegionPath();
            return cache != null && StringUtils.hasText((String)regionPath) ? cache.getRegion(regionPath) : null;
        });
    }

    protected String resolveRegionPath() {
        String regionPath = Optional.ofNullable(this.resolveRegion()).map(Region::getFullPath).orElseGet(this::getRegionPath);
        Assert.state((boolean)StringUtils.hasText((String)regionPath), (String)"Either Region or regionPath must be specified");
        return regionPath;
    }

    @Override
    public void setBeanName(String name) {
        super.setBeanName(name);
        this.setIndexName(name);
    }

    public void setCache(GemFireCache gemfireCache) {
        this.gemfireCache = gemfireCache;
    }

    protected GemFireCache getCache() {
        return this.gemfireCache;
    }

    protected IndexConfigurer getCompositeRegionConfigurer() {
        return this.compositeIndexConfigurer;
    }

    public void setDestroy(boolean destroy) {
        this.destroy = destroy;
    }

    protected boolean isDestroy() {
        return this.destroy;
    }

    public void setFieldAnalyzers(Map<String, Analyzer> fieldAnalyzers) {
        this.fieldAnalyzers = fieldAnalyzers;
    }

    protected Map<String, Analyzer> getFieldAnalyzers() {
        return org.springframework.data.gemfire.util.CollectionUtils.nullSafeMap(this.fieldAnalyzers);
    }

    public void setFields(String ... fields) {
        this.setFields(Arrays.asList(ArrayUtils.nullSafeArray(fields, String.class)));
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    protected List<String> getFields() {
        return org.springframework.data.gemfire.util.CollectionUtils.nullSafeList(this.fields);
    }

    public void setIndexConfigurers(IndexConfigurer ... indexConfigurers) {
        this.setIndexConfigurers(Arrays.asList(ArrayUtils.nullSafeArray(indexConfigurers, IndexConfigurer.class)));
    }

    public void setIndexConfigurers(List<IndexConfigurer> indexConfigurers) {
        this.indexConfigurers = Optional.ofNullable(indexConfigurers).orElseGet(Collections::emptyList);
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    protected String getIndexName() {
        Assert.state((boolean)StringUtils.hasText((String)this.indexName), (String)"indexName was not properly initialized");
        return this.indexName;
    }

    public Optional<LuceneIndex> getLuceneIndex() {
        return Optional.ofNullable(this.luceneIndex);
    }

    public LuceneIndexFactoryBean setLuceneIndex(LuceneIndex luceneIndex) {
        this.luceneIndex = luceneIndex;
        return this;
    }

    public void setLuceneSerializer(LuceneSerializer luceneSerializer) {
        this.luceneSerializer = luceneSerializer;
    }

    protected LuceneSerializer getLuceneSerializer() {
        return this.luceneSerializer;
    }

    public void setLuceneService(LuceneService luceneService) {
        this.luceneService = luceneService;
    }

    protected LuceneService getLuceneService() {
        return this.luceneService;
    }

    public void setRegion(Region<?, ?> region) {
        this.region = region;
    }

    protected Region<?, ?> getRegion() {
        return this.region;
    }

    public void setRegionPath(String pathname) {
        this.regionPath = pathname;
    }

    protected String getRegionPath() {
        return this.regionPath;
    }
}

