/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.support;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.Declarable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.event.ApplicationContextEvent;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.data.gemfire.util.CacheUtils;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SpringContextBootstrappingInitializer
implements Declarable,
ApplicationListener<ApplicationContextEvent> {
    public static final String BASE_PACKAGES_PARAMETER = "basePackages";
    public static final String CONTEXT_CONFIG_LOCATIONS_PARAMETER = "contextConfigLocations";
    protected static final String CHARS_TO_DELETE = " \n\t";
    protected static final String COMMA_DELIMITER = ",";
    private static final ApplicationEventMulticaster applicationEventNotifier = new SimpleApplicationEventMulticaster();
    private static final AtomicReference<ClassLoader> beanClassLoaderReference = new AtomicReference<Object>(null);
    static volatile ConfigurableApplicationContext applicationContext;
    static volatile ContextRefreshedEvent contextRefreshedEvent;
    private static final List<Class<?>> registeredAnnotatedClasses;
    protected final Logger logger = this.initLogger();

    public static synchronized ConfigurableApplicationContext getApplicationContext() {
        Assert.state((applicationContext != null ? 1 : 0) != 0, (String)"A Spring ApplicationContext was not configured and initialized properly");
        return applicationContext;
    }

    public static void setBeanClassLoader(ClassLoader beanClassLoader) {
        if (!SpringContextBootstrappingInitializer.isApplicationContextInitializable()) {
            throw new IllegalStateException("A Spring ApplicationContext has already been initialized");
        }
        beanClassLoaderReference.set(beanClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void notifyOnExistingContextRefreshedEvent(ApplicationListener<ContextRefreshedEvent> listener) {
        ApplicationEventMulticaster applicationEventMulticaster = applicationEventNotifier;
        synchronized (applicationEventMulticaster) {
            if (contextRefreshedEvent != null) {
                listener.onApplicationEvent((ApplicationEvent)contextRefreshedEvent);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ApplicationListener<ContextRefreshedEvent>> T register(T listener) {
        ApplicationEventMulticaster applicationEventMulticaster = applicationEventNotifier;
        synchronized (applicationEventMulticaster) {
            applicationEventNotifier.addApplicationListener(listener);
            SpringContextBootstrappingInitializer.notifyOnExistingContextRefreshedEvent(listener);
        }
        return listener;
    }

    public static boolean register(Class<?> annotatedClass) {
        Assert.notNull(annotatedClass, (String)"The Spring annotated class to register must not be null");
        return registeredAnnotatedClasses.add(annotatedClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ApplicationListener<ContextRefreshedEvent>> T unregister(T listener) {
        ApplicationEventMulticaster applicationEventMulticaster = applicationEventNotifier;
        synchronized (applicationEventMulticaster) {
            applicationEventNotifier.removeApplicationListener(listener);
        }
        return listener;
    }

    public static boolean unregister(Class<?> annotatedClass) {
        return registeredAnnotatedClasses.remove(annotatedClass);
    }

    protected Logger initLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    private boolean isConfigurable(Collection<Class<?>> annotatedClasses, String[] basePackages, String[] contextConfigLocations) {
        return !CollectionUtils.isEmpty(annotatedClasses) || !ObjectUtils.isEmpty((Object[])basePackages) || !ObjectUtils.isEmpty((Object[])contextConfigLocations);
    }

    protected ConfigurableApplicationContext createApplicationContext(String[] basePackages, String[] configLocations) {
        String message = "'AnnotatedClasses', 'basePackages' or 'configLocations' must be specified in order to construct and configure an instance of the ConfigurableApplicationContext";
        Assert.isTrue((boolean)this.isConfigurable(registeredAnnotatedClasses, basePackages, configLocations), (String)message);
        Class[] annotatedClasses = registeredAnnotatedClasses.toArray(new Class[0]);
        ConfigurableApplicationContext applicationContext = this.createApplicationContext(configLocations);
        return this.scanBasePackages(this.registerAnnotatedClasses(applicationContext, annotatedClasses), basePackages);
    }

    ConfigurableApplicationContext createApplicationContext(String[] configLocations) {
        return ObjectUtils.isEmpty((Object[])configLocations) ? new AnnotationConfigApplicationContext() : new ClassPathXmlApplicationContext(configLocations, false);
    }

    protected ConfigurableApplicationContext initApplicationContext(ConfigurableApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, (String)"ConfigurableApplicationContext must not be null");
        applicationContext.addApplicationListener((ApplicationListener)this);
        applicationContext.registerShutdownHook();
        return this.setClassLoader(applicationContext);
    }

    protected ConfigurableApplicationContext refreshApplicationContext(ConfigurableApplicationContext applicationContext) {
        Assert.notNull((Object)applicationContext, (String)"ConfigurableApplicationContext must not be null");
        applicationContext.refresh();
        return applicationContext;
    }

    ConfigurableApplicationContext registerAnnotatedClasses(ConfigurableApplicationContext applicationContext, Class<?>[] annotatedClasses) {
        return applicationContext instanceof AnnotationConfigApplicationContext && !ObjectUtils.isEmpty((Object[])annotatedClasses) ? this.doRegister(applicationContext, annotatedClasses) : applicationContext;
    }

    ConfigurableApplicationContext doRegister(ConfigurableApplicationContext applicationContext, Class<?>[] annotatedClasses) {
        ((AnnotationConfigApplicationContext)applicationContext).register((Class[])annotatedClasses);
        return applicationContext;
    }

    ConfigurableApplicationContext scanBasePackages(ConfigurableApplicationContext applicationContext, String[] basePackages) {
        return applicationContext instanceof AnnotationConfigApplicationContext && !ObjectUtils.isEmpty((Object[])basePackages) ? this.doScan(applicationContext, basePackages) : applicationContext;
    }

    ConfigurableApplicationContext doScan(ConfigurableApplicationContext applicationContext, String[] basePackages) {
        ((AnnotationConfigApplicationContext)applicationContext).scan(basePackages);
        return applicationContext;
    }

    ConfigurableApplicationContext setClassLoader(ConfigurableApplicationContext applicationContext) {
        ClassLoader beanClassLoader = beanClassLoaderReference.get();
        if (applicationContext instanceof DefaultResourceLoader && beanClassLoader != null) {
            ((DefaultResourceLoader)applicationContext).setClassLoader(beanClassLoader);
        }
        return applicationContext;
    }

    public void init(Properties parameters) {
        this.init(CacheUtils.getCache(), parameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Cache cache, Properties parameters) {
        try {
            Class<SpringContextBootstrappingInitializer> clazz = SpringContextBootstrappingInitializer.class;
            synchronized (SpringContextBootstrappingInitializer.class) {
                if (SpringContextBootstrappingInitializer.isApplicationContextInitializable()) {
                    String basePackages = parameters.getProperty(BASE_PACKAGES_PARAMETER);
                    String contextConfigLocations = parameters.getProperty(CONTEXT_CONFIG_LOCATIONS_PARAMETER);
                    Object[] basePackagesArray = StringUtils.delimitedListToStringArray((String)StringUtils.trimWhitespace((String)basePackages), (String)COMMA_DELIMITER, (String)CHARS_TO_DELETE);
                    Object[] contextConfigLocationsArray = StringUtils.delimitedListToStringArray((String)StringUtils.trimWhitespace((String)contextConfigLocations), (String)COMMA_DELIMITER, (String)CHARS_TO_DELETE);
                    ConfigurableApplicationContext localApplicationContext = this.refreshApplicationContext(this.initApplicationContext(this.createApplicationContext((String[])basePackagesArray, (String[])contextConfigLocationsArray)));
                    Assert.state((boolean)localApplicationContext.isRunning(), (String)String.format("The Spring ApplicationContext (%1$s) failed to be properly initialized with the context config files (%2$s) or base packages (%3$s)!", this.nullSafeGetApplicationContextId((ApplicationContext)localApplicationContext), Arrays.toString(contextConfigLocationsArray), Arrays.toString(basePackagesArray)));
                    applicationContext = localApplicationContext;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        }
        catch (Throwable cause) {
            String message = "Failed to bootstrap the Spring ApplicationContext";
            this.logger.error(message, cause);
            throw new ApplicationContextException(message, cause);
        }
        {
            return;
        }
    }

    private static boolean isApplicationContextInitializable() {
        return applicationContext == null || !applicationContext.isActive();
    }

    String nullSafeGetApplicationContextId(ApplicationContext applicationContext) {
        return applicationContext != null ? applicationContext.getId() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ApplicationContextEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            ApplicationEventMulticaster applicationEventMulticaster = applicationEventNotifier;
            synchronized (applicationEventMulticaster) {
                contextRefreshedEvent = (ContextRefreshedEvent)event;
                applicationEventNotifier.multicastEvent((ApplicationEvent)event);
            }
        }
        if (event instanceof ContextClosedEvent) {
            ApplicationEventMulticaster applicationEventMulticaster = applicationEventNotifier;
            synchronized (applicationEventMulticaster) {
                contextRefreshedEvent = null;
            }
        }
    }

    static {
        registeredAnnotatedClasses = new CopyOnWriteArrayList();
    }
}

