/*
 * Copyright 2020 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 */
package org.springframework.data.gemfire.function.execution;

import java.lang.reflect.Method;
import java.util.Set;

import org.springframework.data.gemfire.util.ArrayUtils;

/**
 * @author David Turanski
 * @author John Blum
 */
public class OnRegionFunctionProxyFactoryBean extends GemfireFunctionProxyFactoryBean {

	private final RegionFunctionExecutionMethodMetadata methodMetadata;

	/**
	 * @param serviceInterface the Service class interface specifying the operations to proxy.
	 * @param gemfireOnRegionOperations an {@link GemfireOnRegionOperations} instance
	 */
	public OnRegionFunctionProxyFactoryBean(Class<?> serviceInterface,
			GemfireOnRegionOperations gemfireOnRegionOperations) {

		super(serviceInterface, gemfireOnRegionOperations);

		this.methodMetadata = new RegionFunctionExecutionMethodMetadata(serviceInterface);
	}

	@Override
	protected Iterable<?> invokeFunction(Method method, Object[] args) {

		GemfireOnRegionOperations gemfireOnRegionOperations =
			(GemfireOnRegionOperations) getGemfireFunctionOperations();

		RegionMethodMetadata regionMethodMetadata = this.methodMetadata.getMethodMetadata(method);

		int filterArgPosition = regionMethodMetadata.getFilterArgPosition();

		String functionId = regionMethodMetadata.getFunctionId();

		Set<?> filter = null;

		// extract filter from args if necessary
		if (filterArgPosition >= 0) {
			filter = (Set<?>) args[filterArgPosition];
			args = ArrayUtils.remove(args, filterArgPosition);
		}

		return filter != null ? gemfireOnRegionOperations.execute(functionId, filter, args)
			: gemfireOnRegionOperations.execute(functionId, args);
	}
}
