/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.cascading;

import cascading.stats.CascadingStats;
import org.apache.hadoop.mapred.Task;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.scope.context.StepContext;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.data.hadoop.cascading.CascadingExecutor;

public class CascadingTasklet
extends CascadingExecutor
implements Tasklet {
    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        StepContext context = StepSynchronizationManager.getContext();
        StepExecution stepExecution = context != null ? context.getStepExecution() : null;
        boolean stopped = false;
        if (this.waitToComplete) {
            int i;
            this.uow.start();
            CascadingStats stats = this.uow.getStats();
            while (!stats.isFinished() && !stopped) {
                if (stepExecution.isTerminateOnly()) {
                    this.log.info((Object)("Killing Cascading UoW [" + this.uow.getID() + "]"));
                    stopped = true;
                    this.uow.stop();
                    continue;
                }
                Thread.sleep(5500L);
            }
            if (!stopped) {
                this.uow.complete();
            }
            stats = this.uow.getStats();
            while (!stats.isFinished()) {
                Thread.sleep(5000L);
            }
            for (i = 0; i < CascadingTasklet.safeLongToInt(stats.getCounterValue((Enum)Task.Counter.MAP_INPUT_BYTES)); ++i) {
                contribution.incrementReadCount();
            }
            contribution.incrementReadSkipCount(CascadingTasklet.safeLongToInt(stats.getCounterValue((Enum)Task.Counter.MAP_SKIPPED_RECORDS)));
            contribution.incrementWriteCount(CascadingTasklet.safeLongToInt(stats.getCounterValue((Enum)Task.Counter.REDUCE_OUTPUT_RECORDS)));
            for (i = 0; i < CascadingTasklet.safeLongToInt(stats.getCounterValue((Enum)Task.Counter.REDUCE_SKIPPED_RECORDS)); ++i) {
                contribution.incrementWriteSkipCount();
            }
        } else {
            this.uow.start();
        }
        return RepeatStatus.FINISHED;
    }

    static int safeLongToInt(long l) {
        if (l < Integer.MIN_VALUE || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(l + " cannot be cast to int without changing its value.");
        }
        return (int)l;
    }
}

