/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.fs;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.Assert;

class ChainedResourceLoader
implements ApplicationContextAware,
InitializingBean,
ResourcePatternResolver,
BeanFactoryPostProcessor,
Ordered {
    private ResourcePatternResolver fallback;
    private Map<String, ResourceLoader> resourceLoaders = new ConcurrentHashMap<String, ResourceLoader>(4);
    private Map<String, ResourcePatternResolver> patternLoaders = new ConcurrentHashMap<String, ResourcePatternResolver>(4);
    private Map<String, ? extends ResourceLoader> loaders = Collections.emptyMap();

    ChainedResourceLoader() {
    }

    public void setLoaders(Map<String, ? extends ResourceLoader> loaders) {
        Assert.notNull(loaders, (String)"a valid map of loaders required");
        this.loaders = loaders;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.fallback, (String)"a default resource loader is required");
        for (Map.Entry<String, ? extends ResourceLoader> entry : this.loaders.entrySet()) {
            ResourceLoader loader = entry.getValue();
            this.resourceLoaders.put(entry.getKey(), loader);
            if (!(loader instanceof ResourcePatternResolver)) continue;
            this.patternLoaders.put(entry.getKey(), (ResourcePatternResolver)loader);
        }
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        ResourcePatternResolver pResolver = this.resolvePatternResolver(locationPattern);
        return pResolver.getResources(locationPattern);
    }

    public Resource getResource(String location) {
        ResourceLoader resourceLoader = this.resolveResourceLoader(location);
        return resourceLoader.getResource(location);
    }

    public ClassLoader getClassLoader() {
        return this.fallback.getClassLoader();
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (this.fallback == null) {
            this.fallback = applicationContext;
        }
        if (applicationContext instanceof GenericApplicationContext) {
            ((GenericApplicationContext)applicationContext).setResourceLoader((ResourceLoader)this);
        }
    }

    private String getPrefix(String location) {
        int indexOf = location.indexOf("://");
        return indexOf > 0 ? location.substring(indexOf) : null;
    }

    private ResourcePatternResolver resolvePatternResolver(String locationPattern) {
        String prefix = this.getPrefix(locationPattern);
        return prefix != null ? this.patternLoaders.get(prefix) : this.fallback;
    }

    private ResourceLoader resolveResourceLoader(String location) {
        String prefix = this.getPrefix(location);
        ResourcePatternResolver rl = prefix != null ? this.resourceLoaders.get(prefix) : this.fallback;
        return rl == null ? this.fallback : rl;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        Assert.notNull((Object)this.fallback);
    }

    public void setFallback(ResourcePatternResolver fallback) {
        this.fallback = fallback;
    }
}

