/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.fs;

import java.util.LinkedHashMap;
import org.springframework.beans.BeansException;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.support.ResourceEditorRegistrar;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.Ordered;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.data.hadoop.fs.ChainedResourceLoader;

public class CustomResourceLoaderRegistrar
implements ApplicationContextAware,
BeanFactoryPostProcessor,
Ordered {
    private ChainedResourceLoader chain;
    private ResourcePatternResolver loader;

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        beanFactory.addPropertyEditorRegistrar((PropertyEditorRegistrar)new ResourceEditorRegistrar((ResourceLoader)this.chain));
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.chain = new ChainedResourceLoader();
        this.chain.setFallback(this.loader);
        this.chain.setApplicationContext(applicationContext);
        LinkedHashMap<String, ApplicationContext> loaders = new LinkedHashMap<String, ApplicationContext>();
        loaders.put("classpath", applicationContext);
        this.chain.setLoaders(loaders);
        this.chain.afterPropertiesSet();
    }

    public void setLoader(ResourcePatternResolver loader) {
        this.loader = loader;
    }
}

