/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.fs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RawLocalFileSystem;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.springframework.core.io.ContextResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class HdfsResource
implements ContextResource {
    private final String location;
    private final Path path;
    private final FileSystem fs;
    private boolean exists;
    private final FileStatus status;
    private final CompressionCodecFactory codecsFactory;

    HdfsResource(String location, FileSystem fs, CompressionCodecFactory codecsFactory) {
        this(location, null, fs, codecsFactory);
    }

    HdfsResource(String parent, String child, FileSystem fs, CompressionCodecFactory codecsFactory) {
        this(StringUtils.hasText((String)child) ? new Path(new Path(URI.create(parent)), new Path(URI.create(child))) : new Path(URI.create(parent)), fs, codecsFactory);
    }

    HdfsResource(Path path, FileSystem fs, CompressionCodecFactory codecsFactory) {
        Assert.notNull((Object)path, (String)"a valid path is required");
        Assert.notNull((Object)fs, (String)"non null file system required");
        this.location = path.toString();
        this.fs = fs;
        this.path = path.makeQualified(fs);
        boolean exists = false;
        try {
            exists = fs.exists(path);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.exists = exists;
        FileStatus status = null;
        try {
            status = fs.getFileStatus(path);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.status = status;
        this.codecsFactory = codecsFactory;
    }

    public long contentLength() throws IOException {
        if (this.exists && this.status != null) {
            return this.status.getLen();
        }
        throw new IOException("Cannot access the status for " + this.getDescription());
    }

    public Resource createRelative(String relativePath) throws IOException {
        return new HdfsResource(this.location, relativePath, this.fs, this.codecsFactory);
    }

    public boolean exists() {
        return this.exists;
    }

    public String getDescription() {
        return "HDFS Resource for [" + this.location + "]";
    }

    public File getFile() throws IOException {
        if (this.fs instanceof RawLocalFileSystem) {
            return ((RawLocalFileSystem)this.fs).pathToFile(this.path);
        }
        if (this.fs instanceof LocalFileSystem) {
            return ((LocalFileSystem)this.fs).pathToFile(this.path);
        }
        throw new UnsupportedOperationException("Cannot resolve File object for " + this.getDescription());
    }

    public String getFilename() {
        return this.path.getName();
    }

    public URI getURI() throws IOException {
        return this.path.toUri();
    }

    public URL getURL() throws IOException {
        return this.path.toUri().toURL();
    }

    public boolean isOpen() {
        return this.exists;
    }

    public boolean isReadable() {
        return this.exists;
    }

    public long lastModified() throws IOException {
        if (this.exists && this.status != null) {
            return this.status.getModificationTime();
        }
        throw new IOException("Cannot get timestamp for " + this.getDescription());
    }

    public InputStream getInputStream() throws IOException {
        if (this.exists) {
            CompressionCodec codec;
            FSDataInputStream stream = this.fs.open(this.path);
            if (this.codecsFactory != null && (codec = this.codecsFactory.getCodec(this.path)) != null) {
                stream = codec.createInputStream((InputStream)stream);
            }
            return stream;
        }
        throw new IOException("Cannot open stream for " + this.getDescription());
    }

    public String toString() {
        return this.getDescription();
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof Resource && ((Resource)obj).getDescription().equals(this.getDescription());
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String getPathWithinContext() {
        return this.path.toUri().getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getOutputStream() throws IOException {
        try {
            FSDataOutputStream fSDataOutputStream = this.fs.create(this.path, true);
            return fSDataOutputStream;
        }
        finally {
            this.exists = true;
        }
    }

    public boolean isWritable() {
        try {
            return this.exists && this.fs.isFile(this.path) || !this.exists;
        }
        catch (IOException ex) {
            return false;
        }
    }

    Path getPath() {
        return this.path;
    }
}

