/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.fs;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.BlockLocation;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Progressable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class SimplerFileSystem
extends FileSystem {
    private final FileSystem fs;

    public SimplerFileSystem(FileSystem fs) {
        Assert.notNull((Object)fs, (String)"fs is required");
        this.fs = fs;
    }

    public void setConf(Configuration conf) {
        if (this.fs != null) {
            this.fs.setConf(conf);
        }
    }

    public Configuration getConf() {
        return this.fs.getConf();
    }

    public int hashCode() {
        return this.fs.hashCode();
    }

    public boolean equals(Object obj) {
        return this.fs.equals(obj);
    }

    public void initialize(URI name, Configuration conf) throws IOException {
        this.fs.initialize(name, conf);
    }

    public URI getUri() {
        return this.fs.getUri();
    }

    public String getCanonicalServiceName() {
        return this.fs.getCanonicalServiceName();
    }

    public String getName() {
        return this.fs.getName();
    }

    public String toString() {
        return this.fs.toString();
    }

    public Path makeQualified(String path) {
        return this.fs.makeQualified(this.path(path));
    }

    public Path makeQualified(Path path) {
        return this.fs.makeQualified(path);
    }

    public BlockLocation[] getFileBlockLocations(FileStatus file, long start, long len) throws IOException {
        return this.fs.getFileBlockLocations(file, start, len);
    }

    public FSDataInputStream open(String f, int bufferSize) throws IOException {
        return this.fs.open(this.path(f), bufferSize);
    }

    public FSDataInputStream open(Path f, int bufferSize) throws IOException {
        return this.fs.open(f, bufferSize);
    }

    public FSDataInputStream open(String f) throws IOException {
        return this.fs.open(this.path(f));
    }

    public FSDataInputStream open(Path f) throws IOException {
        return this.fs.open(f);
    }

    public FSDataOutputStream create(String f) throws IOException {
        return this.fs.create(this.path(f));
    }

    public FSDataOutputStream create(Path f) throws IOException {
        return this.fs.create(f);
    }

    public FSDataOutputStream create(String f, boolean overwrite) throws IOException {
        return this.fs.create(this.path(f), overwrite);
    }

    public FSDataOutputStream create(Path f, boolean overwrite) throws IOException {
        return this.fs.create(f, overwrite);
    }

    public FSDataOutputStream create(String f, Progressable progress) throws IOException {
        return this.fs.create(this.path(f), progress);
    }

    public FSDataOutputStream create(Path f, Progressable progress) throws IOException {
        return this.fs.create(f, progress);
    }

    public FSDataOutputStream create(String f, short replication) throws IOException {
        return this.fs.create(this.path(f), replication);
    }

    public FSDataOutputStream create(Path f, short replication) throws IOException {
        return this.fs.create(f, replication);
    }

    public FSDataOutputStream create(String f, short replication, Progressable progress) throws IOException {
        return this.fs.create(this.path(f), replication, progress);
    }

    public FSDataOutputStream create(Path f, short replication, Progressable progress) throws IOException {
        return this.fs.create(f, replication, progress);
    }

    public FSDataOutputStream create(String f, boolean overwrite, int bufferSize) throws IOException {
        return this.fs.create(this.path(f), overwrite, bufferSize);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize) throws IOException {
        return this.fs.create(f, overwrite, bufferSize);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, Progressable progress) throws IOException {
        return this.fs.create(f, overwrite, bufferSize, progress);
    }

    public FSDataOutputStream create(String f, boolean overwrite, int bufferSize, Progressable progress) throws IOException {
        return this.fs.create(this.path(f), overwrite, bufferSize, progress);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        return this.fs.create(f, overwrite, bufferSize, replication, blockSize);
    }

    public FSDataOutputStream create(String f, boolean overwrite, int bufferSize, short replication, long blockSize) throws IOException {
        return this.fs.create(this.path(f), overwrite, bufferSize, replication, blockSize);
    }

    public FSDataOutputStream create(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.fs.create(f, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream create(String f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.fs.create(this.path(f), overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.fs.create(f, permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public FSDataOutputStream create(String f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.fs.create(this.path(f), permission, overwrite, bufferSize, replication, blockSize, progress);
    }

    public boolean createNewFile(String f) throws IOException {
        return this.fs.createNewFile(this.path(f));
    }

    public boolean createNewFile(Path f) throws IOException {
        return this.fs.createNewFile(f);
    }

    public FSDataOutputStream append(String f) throws IOException {
        return this.fs.append(this.path(f));
    }

    public FSDataOutputStream append(Path f) throws IOException {
        return this.fs.append(f);
    }

    public FSDataOutputStream append(Path f, int bufferSize) throws IOException {
        return this.fs.append(f, bufferSize);
    }

    public FSDataOutputStream append(String f, int bufferSize) throws IOException {
        return this.fs.append(this.path(f), bufferSize);
    }

    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        return this.fs.append(f, bufferSize, progress);
    }

    public FSDataOutputStream append(String f, int bufferSize, Progressable progress) throws IOException {
        return this.fs.append(this.path(f), bufferSize, progress);
    }

    public short getReplication(Path src) throws IOException {
        return this.fs.getReplication(src);
    }

    public short getReplication(String src) throws IOException {
        return this.fs.getReplication(this.path(src));
    }

    public boolean setReplication(Path src, short replication) throws IOException {
        return this.fs.setReplication(src, replication);
    }

    public boolean setReplication(String src, short replication) throws IOException {
        return this.fs.setReplication(this.path(src), replication);
    }

    public boolean rename(Path src, Path dst) throws IOException {
        return this.fs.rename(src, dst);
    }

    public boolean rename(String src, String dst) throws IOException {
        return this.fs.rename(this.path(src), this.path(dst));
    }

    public boolean delete(Path f) throws IOException {
        return this.fs.delete(f);
    }

    public boolean delete(String f) throws IOException {
        return this.fs.delete(this.path(f));
    }

    public boolean delete(Path f, boolean recursive) throws IOException {
        return this.fs.delete(f, recursive);
    }

    public boolean delete(String f, boolean recursive) throws IOException {
        return this.fs.delete(this.path(f), recursive);
    }

    public boolean deleteOnExit(Path f) throws IOException {
        return this.fs.deleteOnExit(f);
    }

    public boolean deleteOnExit(String f) throws IOException {
        return this.fs.deleteOnExit(this.path(f));
    }

    public boolean exists(Path f) throws IOException {
        return this.fs.exists(f);
    }

    public boolean exists(String f) throws IOException {
        return this.fs.exists(this.path(f));
    }

    public boolean isDirectory(Path f) throws IOException {
        return this.fs.isDirectory(f);
    }

    public boolean isDirectory(String f) throws IOException {
        return this.fs.isDirectory(this.path(f));
    }

    public boolean isFile(Path f) throws IOException {
        return this.fs.isFile(f);
    }

    public boolean isFile(String f) throws IOException {
        return this.fs.isFile(this.path(f));
    }

    public long getLength(Path f) throws IOException {
        return this.fs.getLength(f);
    }

    public long getLength(String f) throws IOException {
        return this.fs.getLength(this.path(f));
    }

    public ContentSummary getContentSummary(Path f) throws IOException {
        return this.fs.getContentSummary(f);
    }

    public ContentSummary getContentSummary(String f) throws IOException {
        return this.fs.getContentSummary(this.path(f));
    }

    public FileStatus[] listStatus(Path f) throws IOException {
        return this.fs.listStatus(f);
    }

    public FileStatus[] listStatus(String f) throws IOException {
        return this.fs.listStatus(this.path(f));
    }

    public FileStatus[] listStatus(Path f, PathFilter filter) throws IOException {
        return this.fs.listStatus(f, filter);
    }

    public FileStatus[] listStatus(String f, PathFilter filter) throws IOException {
        return this.fs.listStatus(this.path(f), filter);
    }

    public FileStatus[] listStatus(Path[] files) throws IOException {
        return this.fs.listStatus(files);
    }

    public FileStatus[] listStatus(String[] files) throws IOException {
        return this.fs.listStatus(this.path(files));
    }

    public FileStatus[] listStatus(Path[] files, PathFilter filter) throws IOException {
        return this.fs.listStatus(files, filter);
    }

    public FileStatus[] listStatus(String[] files, PathFilter filter) throws IOException {
        return this.fs.listStatus(this.path(files), filter);
    }

    public FileStatus[] globStatus(Path pathPattern) throws IOException {
        return this.fs.globStatus(pathPattern);
    }

    public FileStatus[] globStatus(String pathPattern) throws IOException {
        return this.fs.globStatus(this.path(pathPattern));
    }

    public FileStatus[] globStatus(Path pathPattern, PathFilter filter) throws IOException {
        return this.fs.globStatus(pathPattern, filter);
    }

    public FileStatus[] globStatus(String pathPattern, PathFilter filter) throws IOException {
        return this.fs.globStatus(this.path(pathPattern), filter);
    }

    public Path getHomeDirectory() {
        return this.fs.getHomeDirectory();
    }

    public Token<?> getDelegationToken(String renewer) throws IOException {
        return this.fs.getDelegationToken(renewer);
    }

    public void setWorkingDirectory(Path new_dir) {
        this.fs.setWorkingDirectory(new_dir);
    }

    public Path getWorkingDirectory() {
        return this.fs.getWorkingDirectory();
    }

    public boolean mkdirs(Path f) throws IOException {
        return this.fs.mkdirs(f);
    }

    public boolean mkdirs(String f) throws IOException {
        return this.fs.mkdirs(this.path(f));
    }

    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        return this.fs.mkdirs(f, permission);
    }

    public boolean mkdirs(String f, short permission) throws IOException {
        return this.fs.mkdirs(this.path(f), new FsPermission(permission));
    }

    public void copyFromLocalFile(Path src, Path dst) throws IOException {
        this.fs.copyFromLocalFile(src, dst);
    }

    public void copyFromLocalFile(String src, String dst) throws IOException {
        this.fs.copyFromLocalFile(this.path(src), this.path(dst));
    }

    public void moveFromLocalFile(Path[] srcs, Path dst) throws IOException {
        this.fs.moveFromLocalFile(srcs, dst);
    }

    public void moveFromLocalFile(String[] srcs, String dst) throws IOException {
        this.fs.moveFromLocalFile(this.path(srcs), this.path(dst));
    }

    public void moveFromLocalFile(Path src, Path dst) throws IOException {
        this.fs.moveFromLocalFile(src, dst);
    }

    public void moveFromLocalFile(String src, String dst) throws IOException {
        this.fs.moveFromLocalFile(this.path(src), this.path(dst));
    }

    public void copyFromLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.fs.copyFromLocalFile(delSrc, src, dst);
    }

    public void copyFromLocalFile(boolean delSrc, String src, String dst) throws IOException {
        this.fs.copyFromLocalFile(delSrc, this.path(src), this.path(dst));
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path[] srcs, Path dst) throws IOException {
        this.fs.copyFromLocalFile(delSrc, overwrite, srcs, dst);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, String[] srcs, String dst) throws IOException {
        this.fs.copyFromLocalFile(delSrc, overwrite, this.path(srcs), this.path(dst));
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, Path src, Path dst) throws IOException {
        this.fs.copyFromLocalFile(delSrc, overwrite, src, dst);
    }

    public void copyFromLocalFile(boolean delSrc, boolean overwrite, String src, String dst) throws IOException {
        this.fs.copyFromLocalFile(delSrc, overwrite, this.path(src), this.path(dst));
    }

    public void copyToLocalFile(Path src, Path dst) throws IOException {
        this.fs.copyToLocalFile(src, dst);
    }

    public void copyToLocalFile(String src, String dst) throws IOException {
        this.fs.copyToLocalFile(this.path(src), this.path(dst));
    }

    public void moveToLocalFile(Path src, Path dst) throws IOException {
        this.fs.moveToLocalFile(src, dst);
    }

    public void moveToLocalFile(String src, String dst) throws IOException {
        this.fs.moveToLocalFile(this.path(src), this.path(dst));
    }

    public void copyToLocalFile(boolean delSrc, Path src, Path dst) throws IOException {
        this.fs.copyToLocalFile(delSrc, src, dst);
    }

    public void copyToLocalFile(boolean delSrc, String src, String dst) throws IOException {
        this.fs.copyToLocalFile(delSrc, this.path(src), this.path(dst));
    }

    public Path startLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        return this.fs.startLocalOutput(fsOutputFile, tmpLocalFile);
    }

    public Path startLocalOutput(String fsOutputFile, String tmpLocalFile) throws IOException {
        return this.fs.startLocalOutput(this.path(fsOutputFile), this.path(tmpLocalFile));
    }

    public void completeLocalOutput(Path fsOutputFile, Path tmpLocalFile) throws IOException {
        this.fs.completeLocalOutput(fsOutputFile, tmpLocalFile);
    }

    public void completeLocalOutput(String fsOutputFile, String tmpLocalFile) throws IOException {
        this.fs.completeLocalOutput(this.path(fsOutputFile), this.path(tmpLocalFile));
    }

    public void close() throws IOException {
        this.fs.close();
    }

    public long getUsed() throws IOException {
        return this.fs.getUsed();
    }

    public long getBlockSize(Path f) throws IOException {
        return this.fs.getBlockSize(f);
    }

    public long getBlockSize(String f) throws IOException {
        return this.fs.getBlockSize(this.path(f));
    }

    public long getDefaultBlockSize() {
        return this.fs.getDefaultBlockSize();
    }

    public short getDefaultReplication() {
        return this.fs.getDefaultReplication();
    }

    public FileStatus getFileStatus(Path f) throws IOException {
        return this.fs.getFileStatus(f);
    }

    public FileStatus getFileStatus(String f) throws IOException {
        return this.fs.getFileStatus(this.path(f));
    }

    public FileChecksum getFileChecksum(Path f) throws IOException {
        return this.fs.getFileChecksum(f);
    }

    public FileChecksum getFileChecksum(String f) throws IOException {
        return this.fs.getFileChecksum(this.path(f));
    }

    public void setVerifyChecksum(boolean verifyChecksum) {
        this.fs.setVerifyChecksum(verifyChecksum);
    }

    public void setPermission(Path p, FsPermission permission) throws IOException {
        this.fs.setPermission(p, permission);
    }

    public void setPermission(String p, short permission) throws IOException {
        this.fs.setPermission(this.path(p), new FsPermission(permission));
    }

    public void setOwner(Path p, String username, String groupname) throws IOException {
        this.fs.setOwner(p, username, groupname);
    }

    public void setOwner(String p, String username, String groupname) throws IOException {
        this.fs.setOwner(this.path(p), username, groupname);
    }

    public void setTimes(Path p, long mtime, long atime) throws IOException {
        this.fs.setTimes(p, mtime, atime);
    }

    public void setTimes(String p, long mtime, long atime) throws IOException {
        this.fs.setTimes(this.path(p), mtime, atime);
    }

    private Path path(String path) {
        return new Path(path);
    }

    private Path[] path(String[] files) {
        Path[] paths = null;
        if (!ObjectUtils.isEmpty((Object[])files)) {
            paths = new Path[files.length];
            for (int i = 0; i < paths.length; ++i) {
                paths[i] = this.path(files[i]);
            }
        } else {
            paths = new Path[]{};
        }
        return paths;
    }
}

