/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.hbase;

import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.HTableInterfaceFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.data.hadoop.hbase.HbaseSynchronizationManager;
import org.springframework.data.hadoop.hbase.HbaseSystemException;
import org.springframework.util.StringUtils;

public class HbaseUtils {
    public static DataAccessException convertHbaseException(Exception ex) {
        return new HbaseSystemException(ex);
    }

    public static HTableInterface getHTable(String tableName, Configuration configuration) {
        return HbaseUtils.getHTable(tableName, configuration, HbaseUtils.getCharset(null), null);
    }

    public static HTableInterface getHTable(String tableName, Configuration configuration, Charset charset, HTableInterfaceFactory tableFactory) {
        if (HbaseSynchronizationManager.hasResource(tableName)) {
            return (HTable)HbaseSynchronizationManager.getResource(tableName);
        }
        Object t = null;
        try {
            t = tableFactory != null ? tableFactory.createHTableInterface(configuration, tableName.getBytes(charset)) : new HTable(configuration, tableName.getBytes(charset));
            return t;
        }
        catch (Exception ex) {
            throw HbaseUtils.convertHbaseException(ex);
        }
    }

    static Charset getCharset(String encoding) {
        return StringUtils.hasText((String)encoding) ? Charset.forName(encoding) : Charset.forName("UTF-8");
    }

    public static void releaseTable(String tableName, HTableInterface table) {
        HbaseUtils.releaseTable(tableName, table, null);
    }

    public static void releaseTable(String tableName, HTableInterface table, HTableInterfaceFactory tableFactory) {
        try {
            HbaseUtils.doReleaseTable(tableName, table, tableFactory);
        }
        catch (IOException ex) {
            throw HbaseUtils.convertHbaseException(ex);
        }
    }

    private static void doReleaseTable(String tableName, HTableInterface table, HTableInterfaceFactory tableFactory) throws IOException {
        if (table == null) {
            return;
        }
        if (!HbaseUtils.isBoundToThread(tableName)) {
            if (tableFactory != null) {
                tableFactory.releaseHTableInterface(table);
            } else {
                table.close();
            }
        }
    }

    private static boolean isBoundToThread(String tableName) {
        return HbaseSynchronizationManager.hasResource(tableName);
    }
}

