/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.hive;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.hadoop.hive.HiveClientFactory;
import org.springframework.data.hadoop.hive.HiveOperations;
import org.springframework.data.hadoop.hive.HiveScript;
import org.springframework.data.hadoop.hive.HiveTemplate;
import org.springframework.util.CollectionUtils;

abstract class HiveExecutor
implements InitializingBean {
    private HiveClientFactory hiveClientFactory;
    private HiveOperations hiveTemplate;
    private Collection<HiveScript> scripts;

    HiveExecutor() {
    }

    public void afterPropertiesSet() throws Exception {
        if (this.hiveClientFactory == null && this.hiveTemplate == null) {
            throw new IllegalArgumentException("a HiveClient factory or a HiveTemplate is required");
        }
        if (this.hiveTemplate == null) {
            this.hiveTemplate = new HiveTemplate(this.hiveClientFactory);
        }
    }

    protected List<String> executeHiveScripts() {
        if (CollectionUtils.isEmpty(this.scripts)) {
            return Collections.emptyList();
        }
        return this.hiveTemplate.executeScript(this.scripts);
    }

    public void setScripts(Collection<HiveScript> scripts) {
        this.scripts = scripts;
    }

    public void setHiveClientFactory(HiveClientFactory hiveClientFactory) {
        this.hiveClientFactory = hiveClientFactory;
    }

    public void setHiveTemplate(HiveOperations hiveTemplate) {
        this.hiveTemplate = hiveTemplate;
    }
}

