/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.hive;

import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.ServerUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.processors.CommandProcessorFactory;
import org.apache.hadoop.hive.service.HiveServer;
import org.apache.thrift.TProcessorFactory;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.data.hadoop.configuration.ConfigurationUtils;

public class HiveServerFactoryBean
implements FactoryBean<TServer>,
InitializingBean,
DisposableBean,
SmartLifecycle {
    private boolean autoStartup = true;
    private TServer server;
    private int port = 10000;
    private int minThreads = 10;
    private int maxThreads = 100;
    private Configuration configuration;
    private Executor executor;
    private Properties properties;
    private HiveConf conf;

    public void destroy() {
        this.stop();
        CommandProcessorFactory.clean((HiveConf)this.conf);
        this.server = null;
    }

    public void afterPropertiesSet() throws Exception {
        Configuration cfg = ConfigurationUtils.createFrom(this.configuration, this.properties);
        this.conf = new HiveConf(cfg, HiveServer.HiveServerHandler.class);
        ServerUtils.cleanUpScratchDir((HiveConf)this.conf);
        TServerSocket serverTransport = new TServerSocket(this.port);
        HiveServer.ThriftHiveProcessorFactory hfactory = new HiveServer.ThriftHiveProcessorFactory(null, this.conf);
        TThreadPoolServer.Args sargs = ((TThreadPoolServer.Args)((TThreadPoolServer.Args)((TThreadPoolServer.Args)new TThreadPoolServer.Args((TServerTransport)serverTransport).processorFactory((TProcessorFactory)hfactory)).transportFactory(new TTransportFactory())).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory())).minWorkerThreads(this.minThreads).maxWorkerThreads(this.maxThreads);
        this.server = new TThreadPoolServer(sargs);
        if (this.executor == null) {
            this.executor = new SimpleAsyncTaskExecutor(this.getClass().getSimpleName());
        }
    }

    public TServer getObject() {
        return this.server;
    }

    public Class<?> getObjectType() {
        return this.server != null ? this.server.getClass() : TServer.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void start() {
        if (!this.isRunning()) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    HiveServerFactoryBean.this.server.serve();
                }
            });
        }
    }

    public void stop() {
        if (this.isRunning()) {
            this.server.stop();
        }
    }

    public boolean isRunning() {
        return this.server.isServing();
    }

    public int getPhase() {
        return Integer.MIN_VALUE;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setMinThreads(int minThreads) {
        this.minThreads = minThreads;
    }

    public void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }
}

