/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.mapreduce;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapreduce.Job;
import org.springframework.data.hadoop.configuration.ConfigurationUtils;
import org.springframework.data.hadoop.util.VersionUtils;
import org.springframework.util.ReflectionUtils;

public abstract class JobUtils {
    static Field JOB_INFO;
    static Field JOB_CLIENT_STATE;

    public static RunningJob getRunningJob(Job job) {
        if (job == null) {
            return null;
        }
        if (VersionUtils.isHadoop2X()) {
            try {
                Configuration cfg = job.getConfiguration();
                cfg.set("mapreduce.framework.name", "yarn");
                JobClient jobClient = null;
                try {
                    Constructor constr = JobClient.class.getConstructor(Configuration.class);
                    jobClient = (JobClient)constr.newInstance(cfg);
                }
                catch (Exception e) {
                    jobClient = new JobClient();
                }
                JobID id = JobUtils.getOldJobId(job);
                if (id != null) {
                    return jobClient.getJob(id);
                }
                return null;
            }
            catch (IOException e) {
                return null;
            }
        }
        return (RunningJob)ReflectionUtils.getField((Field)JOB_INFO, (Object)job);
    }

    public static org.apache.hadoop.mapreduce.JobID getJobId(Job job) {
        if (job == null) {
            return null;
        }
        return job.getJobID();
    }

    public static JobID getOldJobId(Job job) {
        if (job == null) {
            return null;
        }
        org.apache.hadoop.mapreduce.JobID id = JobUtils.getJobId(job);
        if (id != null) {
            return JobID.downgrade((org.apache.hadoop.mapreduce.JobID)id);
        }
        return null;
    }

    public static JobConf getJobConf(Job job) {
        if (job == null) {
            return null;
        }
        Configuration configuration = job.getConfiguration();
        if (configuration instanceof JobConf) {
            return (JobConf)configuration;
        }
        return (JobConf)ConfigurationUtils.createFrom(configuration, null);
    }

    public static JobStatus getStatus(Job job) {
        if (job == null) {
            return JobStatus.UNKNOWN;
        }
        RunningJob runningJob = JobUtils.getRunningJob(job);
        if (runningJob != null) {
            try {
                return JobStatus.fromRunState(runningJob.getJobState());
            }
            catch (IOException ex) {
                return JobStatus.UNKNOWN;
            }
        }
        return JobStatus.DEFINED;
    }

    static {
        if (!VersionUtils.isHadoop2X()) {
            JOB_INFO = ReflectionUtils.findField(Job.class, (String)"info");
            if (JOB_INFO == null) {
                throw new IllegalStateException("Invalid Job.class detected, probably caused by a Hadoop YARN library, which is NOT supported yet.\nSee the Requirements chapter in the reference documentation for more information.");
            }
            ReflectionUtils.makeAccessible((Field)JOB_INFO);
        }
        JOB_CLIENT_STATE = ReflectionUtils.findField(Job.class, (String)"state");
        ReflectionUtils.makeAccessible((Field)JOB_CLIENT_STATE);
    }

    public static enum JobStatus {
        UNKNOWN,
        DEFINED,
        PREPARING,
        RUNNING,
        SUCCEEDED,
        FAILED,
        KILLED;


        public static JobStatus fromRunState(int state) {
            switch (state) {
                case 1: {
                    return RUNNING;
                }
                case 2: {
                    return SUCCEEDED;
                }
                case 3: {
                    return FAILED;
                }
                case 4: {
                    return PREPARING;
                }
                case 5: {
                    return KILLED;
                }
            }
            return UNKNOWN;
        }

        public static JobStatus fromJobState(Job.JobState jobState) {
            switch (jobState) {
                case DEFINE: {
                    return DEFINED;
                }
                case RUNNING: {
                    return RUNNING;
                }
            }
            return UNKNOWN;
        }

        public boolean isRunning() {
            return PREPARING == this || RUNNING == this;
        }

        public boolean isFinished() {
            return SUCCEEDED == this || FAILED == this || KILLED == this;
        }

        public boolean isStarted() {
            return DEFINED != this;
        }
    }
}

