/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.scripting;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.hadoop.scripting.EvaluationPolicy;
import org.springframework.data.hadoop.scripting.Jsr223ScriptEvaluator;
import org.springframework.scripting.ScriptSource;

class Jsr223ScriptRunner
implements InitializingBean,
BeanClassLoaderAware,
Callable<Object> {
    private ClassLoader classLoader;
    private ScriptSource script;
    private Jsr223ScriptEvaluator evaluator;
    private String language;
    private String extension;
    private Map<String, Object> arguments;
    private EvaluationPolicy evaluation = EvaluationPolicy.ALWAYS;
    private final Object monitor = new Object();
    private volatile boolean evaluated;
    private Object result = null;
    private boolean runAtStartup = false;
    private Iterable<Callable<?>> preActions;
    private Iterable<Callable<?>> postActions;

    Jsr223ScriptRunner() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object call() throws Exception {
        Object res;
        this.invoke(this.preActions);
        switch (this.evaluation) {
            case ONCE: {
                if (!this.evaluated) {
                    Object object = this.monitor;
                    synchronized (object) {
                        if (!this.evaluated) {
                            this.evaluated = true;
                            this.result = this.evaluator.evaluate(this.script, this.arguments);
                        }
                    }
                }
                res = this.result;
                break;
            }
            case IF_MODIFIED: {
                if (this.script.isModified()) {
                    this.result = this.evaluator.evaluate(this.script, this.arguments);
                }
                res = this.result;
                break;
            }
            default: {
                res = this.evaluator.evaluate(this.script, this.arguments);
            }
        }
        this.invoke(this.postActions);
        return res;
    }

    public void afterPropertiesSet() throws Exception {
        this.evaluator = new Jsr223ScriptEvaluator(this.classLoader);
        this.evaluator.setLanguage(this.language);
        this.evaluator.setExtension(this.extension);
        if (this.arguments == null) {
            this.arguments = new LinkedHashMap<String, Object>();
        }
        this.postProcess(this.arguments);
        if (this.runAtStartup) {
            this.call();
        }
    }

    protected void postProcess(Map<String, Object> arguments) {
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setScriptSource(ScriptSource script) {
        this.script = script;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setEvaluate(EvaluationPolicy evaluation) {
        this.evaluation = evaluation;
    }

    public void setArguments(Map<String, Object> arguments) {
        this.arguments = arguments;
    }

    public boolean isRunAtStartup() {
        return this.runAtStartup;
    }

    public void setRunAtStartup(boolean runAtStartup) {
        this.runAtStartup = runAtStartup;
    }

    public void setPreAction(Collection<Callable<?>> actions) {
        this.preActions = actions;
    }

    public void setPostAction(Collection<Callable<?>> actions) {
        this.postActions = actions;
    }

    private void invoke(Iterable<Callable<?>> actions) throws Exception {
        if (actions != null) {
            for (Callable<?> action : actions) {
                action.call();
            }
        }
    }
}

