/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.util;

import java.lang.reflect.Field;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapreduce.JobSubmissionFiles;
import org.springframework.util.ReflectionUtils;

public class PermissionUtils {
    private static final Log log = LogFactory.getLog(PermissionUtils.class);
    private static Class<?> trackerDistributedCacheManagerClass;

    public static void hackHadoopStagingOnWin() {
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            JobSubmissionFiles.JOB_DIR_PERMISSION.fromShort((short)424);
            JobSubmissionFiles.JOB_FILE_PERMISSION.fromShort((short)424);
            if (trackerDistributedCacheManagerClass != null) {
                Field field = ReflectionUtils.findField(trackerDistributedCacheManagerClass, (String)"PUBLIC_CACHE_OBJECT_PERM");
                ReflectionUtils.makeAccessible((Field)field);
                FsPermission perm = (FsPermission)ReflectionUtils.getField((Field)field, null);
                perm.fromShort((short)424);
            }
        }
    }

    static {
        if (System.getProperty("os.name").toLowerCase().startsWith("win")) {
            try {
                trackerDistributedCacheManagerClass = Class.forName("org.apache.hadoop.filecache.TrackerDistributedCacheManager");
            }
            catch (ClassNotFoundException e) {
                trackerDistributedCacheManagerClass = null;
                log.warn((Object)("Unable to provide Windows jar permission fix: " + e.getMessage()));
                e.printStackTrace();
            }
        }
    }
}

