/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.config.namespace;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.data.hadoop.config.namespace.AbstractImprovedSimpleBeanDefinitionParser;
import org.springframework.data.hadoop.fs.DistributedCacheFactoryBean;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

class DistributedCacheParser
extends AbstractImprovedSimpleBeanDefinitionParser {
    DistributedCacheParser() {
    }

    protected Class<?> getBeanClass(Element element) {
        return DistributedCacheFactoryBean.class;
    }

    @Override
    protected String defaultId(ParserContext context, Element element) {
        return "hadoopCache";
    }

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        ManagedList entries = new ManagedList();
        this.parseEntries(element, "classpath", DistributedCacheFactoryBean.CacheEntry.EntryType.CP, (List<BeanDefinition>)entries);
        this.parseEntries(element, "cache", DistributedCacheFactoryBean.CacheEntry.EntryType.CACHE, (List<BeanDefinition>)entries);
        this.parseEntries(element, "local", DistributedCacheFactoryBean.CacheEntry.EntryType.LOCAL, (List<BeanDefinition>)entries);
        builder.addPropertyValue("entries", (Object)entries);
    }

    private void parseEntries(Element element, String name, DistributedCacheFactoryBean.CacheEntry.EntryType type, List<BeanDefinition> entries) {
        List cp = DomUtils.getChildElementsByTagName((Element)element, (String)name);
        for (Element entry : cp) {
            BeanDefinitionBuilder bd = BeanDefinitionBuilder.genericBeanDefinition(DistributedCacheFactoryBean.CacheEntry.class);
            bd.addConstructorArgValue((Object)type);
            bd.addConstructorArgValue((Object)entry.getAttribute("value"));
            entries.add((BeanDefinition)bd.getBeanDefinition());
        }
    }
}

