/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import org.springframework.beans.BeanUtils;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.data.jdbc.repository.support.JdbcQueryMethod;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class JdbcRepositoryQuery
implements RepositoryQuery {
    private static final String PARAMETER_NEEDS_TO_BE_NAMED = "For queries with named parameters you need to provide names for method parameters. Use @Param for query method parameters, or when on Java 8+ use the javac flag -parameters.";
    private final JdbcQueryMethod queryMethod;
    private final NamedParameterJdbcOperations operations;
    private final RowMapper<?> rowMapper;

    JdbcRepositoryQuery(JdbcQueryMethod queryMethod, NamedParameterJdbcOperations operations, @Nullable RowMapper<?> defaultRowMapper) {
        Assert.notNull((Object)((Object)queryMethod), (String)"Query method must not be null!");
        Assert.notNull((Object)operations, (String)"NamedParameterJdbcOperations must not be null!");
        if (!queryMethod.isModifyingQuery()) {
            Assert.notNull(defaultRowMapper, (String)"RowMapper must not be null!");
        }
        this.queryMethod = queryMethod;
        this.operations = operations;
        this.rowMapper = JdbcRepositoryQuery.createRowMapper(queryMethod, defaultRowMapper);
    }

    public Object execute(Object[] objects) {
        String query = this.determineQuery();
        MapSqlParameterSource parameters = this.bindParameters(objects);
        if (this.queryMethod.isModifyingQuery()) {
            int updatedCount = this.operations.update(query, (SqlParameterSource)parameters);
            Class returnedObjectType = this.queryMethod.getReturnedObjectType();
            return returnedObjectType == Boolean.TYPE || returnedObjectType == Boolean.class ? (Comparable<Boolean>)Boolean.valueOf(updatedCount != 0) : (Comparable<Boolean>)Integer.valueOf(updatedCount);
        }
        if (this.queryMethod.isCollectionQuery() || this.queryMethod.isStreamQuery()) {
            return this.operations.query(query, (SqlParameterSource)parameters, this.rowMapper);
        }
        try {
            return this.operations.queryForObject(query, (SqlParameterSource)parameters, this.rowMapper);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public JdbcQueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    private String determineQuery() {
        String query = this.queryMethod.getAnnotatedQuery();
        if (StringUtils.isEmpty((Object)query)) {
            throw new IllegalStateException(String.format("No query specified on %s", this.queryMethod.getName()));
        }
        return query;
    }

    private MapSqlParameterSource bindParameters(Object[] objects) {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        this.queryMethod.getParameters().getBindableParameters().forEach(p -> {
            String parameterName = (String)p.getName().orElseThrow(() -> new IllegalStateException(PARAMETER_NEEDS_TO_BE_NAMED));
            parameters.addValue(parameterName, objects[p.getIndex()]);
        });
        return parameters;
    }

    @Nullable
    private static RowMapper<?> createRowMapper(JdbcQueryMethod queryMethod, @Nullable RowMapper<?> defaultRowMapper) {
        Class<?> rowMapperClass = queryMethod.getRowMapperClass();
        return rowMapperClass == null || rowMapperClass == RowMapper.class ? defaultRowMapper : (RowMapper)BeanUtils.instantiateClass(rowMapperClass);
    }
}

