/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.support;

import java.io.Serializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.jdbc.core.DataAccessStrategy;
import org.springframework.data.jdbc.core.DefaultDataAccessStrategy;
import org.springframework.data.jdbc.core.SqlGeneratorSource;
import org.springframework.data.jdbc.repository.RowMapperMap;
import org.springframework.data.jdbc.repository.support.JdbcRepositoryFactory;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.conversion.RelationalConverter;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.TransactionalRepositoryFactoryBeanSupport;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.util.Assert;

public class JdbcRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends TransactionalRepositoryFactoryBeanSupport<T, S, ID>
implements ApplicationEventPublisherAware {
    private ApplicationEventPublisher publisher;
    private RelationalMappingContext mappingContext;
    private RelationalConverter converter;
    private DataAccessStrategy dataAccessStrategy;
    private RowMapperMap rowMapperMap = RowMapperMap.EMPTY;
    private NamedParameterJdbcOperations operations;

    JdbcRepositoryFactoryBean(Class<? extends T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        super.setApplicationEventPublisher(publisher);
        this.publisher = publisher;
    }

    protected RepositoryFactorySupport doCreateRepositoryFactory() {
        JdbcRepositoryFactory jdbcRepositoryFactory = new JdbcRepositoryFactory(this.dataAccessStrategy, this.mappingContext, this.converter, this.publisher, this.operations);
        jdbcRepositoryFactory.setRowMapperMap(this.rowMapperMap);
        return jdbcRepositoryFactory;
    }

    @Autowired
    protected void setMappingContext(RelationalMappingContext mappingContext) {
        super.setMappingContext((MappingContext)mappingContext);
        this.mappingContext = mappingContext;
    }

    @Autowired(required=false)
    public void setDataAccessStrategy(DataAccessStrategy dataAccessStrategy) {
        this.dataAccessStrategy = dataAccessStrategy;
    }

    @Autowired(required=false)
    public void setRowMapperMap(RowMapperMap rowMapperMap) {
        this.rowMapperMap = rowMapperMap;
    }

    @Autowired
    public void setJdbcOperations(NamedParameterJdbcOperations operations) {
        this.operations = operations;
    }

    @Autowired
    public void setConverter(RelationalConverter converter) {
        this.converter = converter;
    }

    public void afterPropertiesSet() {
        Assert.state((this.mappingContext != null ? 1 : 0) != 0, (String)"MappingContext is required and must not be null!");
        Assert.state((this.converter != null ? 1 : 0) != 0, (String)"RelationalConverter is required and must not be null!");
        if (this.dataAccessStrategy == null) {
            SqlGeneratorSource sqlGeneratorSource = new SqlGeneratorSource(this.mappingContext);
            this.dataAccessStrategy = new DefaultDataAccessStrategy(sqlGeneratorSource, this.mappingContext, this.converter, this.operations);
        }
        if (this.rowMapperMap == null) {
            this.rowMapperMap = RowMapperMap.EMPTY;
        }
        super.afterPropertiesSet();
    }
}

