/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.config;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.data.jdbc.repository.QueryMappingConfiguration;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DefaultQueryMappingConfiguration
implements QueryMappingConfiguration {
    private Map<Class<?>, RowMapper<?>> mappers = new LinkedHashMap();

    @Override
    @Nullable
    public <T> RowMapper<? extends T> getRowMapper(Class<T> type) {
        Assert.notNull(type, (String)"Type must not be null");
        RowMapper<?> candidate = this.mappers.get(type);
        if (candidate == null) {
            for (Map.Entry<Class<?>, RowMapper<?>> entry : this.mappers.entrySet()) {
                if (!type.isAssignableFrom(entry.getKey())) continue;
                candidate = entry.getValue();
            }
        }
        return candidate;
    }

    public <T> DefaultQueryMappingConfiguration registerRowMapper(Class<T> type, RowMapper<? extends T> rowMapper) {
        this.mappers.put(type, rowMapper);
        return this;
    }
}

