/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.JDBCType;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.EntityRowMapper;
import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.JdbcValue;
import org.springframework.data.jdbc.core.convert.MapEntityRowMapper;
import org.springframework.data.jdbc.core.convert.SqlGenerator;
import org.springframework.data.jdbc.core.convert.SqlGeneratorSource;
import org.springframework.data.jdbc.core.convert.SqlIdentifierParameterSource;
import org.springframework.data.jdbc.support.JdbcUtil;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.relational.core.dialect.IdGeneration;
import org.springframework.data.relational.core.mapping.PersistentPropertyPathExtension;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.IdentifierProcessing;
import org.springframework.data.relational.core.sql.LockMode;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DefaultDataAccessStrategy
implements DataAccessStrategy {
    private final SqlGeneratorSource sqlGeneratorSource;
    private final RelationalMappingContext context;
    private final JdbcConverter converter;
    private final NamedParameterJdbcOperations operations;

    public DefaultDataAccessStrategy(SqlGeneratorSource sqlGeneratorSource, RelationalMappingContext context, JdbcConverter converter, NamedParameterJdbcOperations operations) {
        Assert.notNull((Object)sqlGeneratorSource, (String)"SqlGeneratorSource must not be null");
        Assert.notNull((Object)context, (String)"RelationalMappingContext must not be null");
        Assert.notNull((Object)converter, (String)"JdbcConverter must not be null");
        Assert.notNull((Object)operations, (String)"NamedParameterJdbcOperations must not be null");
        this.sqlGeneratorSource = sqlGeneratorSource;
        this.context = context;
        this.converter = converter;
        this.operations = operations;
    }

    @Override
    public <T> Object insert(T instance, Class<T> domainType, Identifier identifier) {
        SqlGenerator sqlGenerator = this.sql(domainType);
        RelationalPersistentEntity<T> persistentEntity = this.getRequiredPersistentEntity(domainType);
        SqlIdentifierParameterSource parameterSource = this.getParameterSource(instance, persistentEntity, "", PersistentProperty::isIdProperty, this.getIdentifierProcessing());
        identifier.forEach((name, value, type) -> this.addConvertedPropertyValue(parameterSource, name, value, type));
        Object idValue = this.getIdValueOrNull(instance, persistentEntity);
        if (idValue != null) {
            RelationalPersistentProperty idProperty = (RelationalPersistentProperty)persistentEntity.getRequiredIdProperty();
            this.addConvertedPropertyValue(parameterSource, idProperty, idValue, idProperty.getColumnName());
        }
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        IdGeneration idGeneration = this.sqlGeneratorSource.getDialect().getIdGeneration();
        String insertSql = sqlGenerator.getInsert(new HashSet<SqlIdentifier>(parameterSource.getIdentifiers()));
        if (idGeneration.driverRequiresKeyColumnNames()) {
            String[] keyColumnNames = this.getKeyColumnNames(domainType);
            if (keyColumnNames.length == 0) {
                this.operations.update(insertSql, (SqlParameterSource)parameterSource, (KeyHolder)holder);
            } else {
                this.operations.update(insertSql, (SqlParameterSource)parameterSource, (KeyHolder)holder, keyColumnNames);
            }
        } else {
            this.operations.update(insertSql, (SqlParameterSource)parameterSource, (KeyHolder)holder);
        }
        return this.getIdFromHolder((KeyHolder)holder, persistentEntity);
    }

    public <S> boolean update(S instance, Class<S> domainType) {
        RelationalPersistentEntity<S> persistentEntity = this.getRequiredPersistentEntity(domainType);
        return this.operations.update(this.sql(domainType).getUpdate(), (SqlParameterSource)this.getParameterSource(instance, persistentEntity, "", Predicates.includeAll(), this.getIdentifierProcessing())) != 0;
    }

    public <S> boolean updateWithVersion(S instance, Class<S> domainType, Number previousVersion) {
        RelationalPersistentEntity<S> persistentEntity = this.getRequiredPersistentEntity(domainType);
        SqlIdentifierParameterSource parameterSource = this.getParameterSource(instance, persistentEntity, "", Predicates.includeAll(), this.getIdentifierProcessing());
        parameterSource.addValue(SqlGenerator.VERSION_SQL_PARAMETER, previousVersion);
        int affectedRows = this.operations.update(this.sql(domainType).getUpdateWithVersion(), (SqlParameterSource)parameterSource);
        if (affectedRows == 0) {
            throw new OptimisticLockingFailureException(String.format("Optimistic lock exception on saving entity of type %s.", persistentEntity.getName()));
        }
        return true;
    }

    @Override
    public void delete(Object id, Class<?> domainType) {
        String deleteByIdSql = this.sql(domainType).getDeleteById();
        SqlIdentifierParameterSource parameter = this.createIdParameterSource(id, domainType);
        this.operations.update(deleteByIdSql, (SqlParameterSource)parameter);
    }

    @Override
    public <T> void deleteWithVersion(Object id, Class<T> domainType, Number previousVersion) {
        Assert.notNull((Object)id, (String)"Id must not be null.");
        RelationalPersistentEntity<T> persistentEntity = this.getRequiredPersistentEntity(domainType);
        SqlIdentifierParameterSource parameterSource = this.createIdParameterSource(id, domainType);
        parameterSource.addValue(SqlGenerator.VERSION_SQL_PARAMETER, previousVersion);
        int affectedRows = this.operations.update(this.sql(domainType).getDeleteByIdAndVersion(), (SqlParameterSource)parameterSource);
        if (affectedRows == 0) {
            throw new OptimisticLockingFailureException(String.format("Optimistic lock exception deleting entity of type %s.", persistentEntity.getName()));
        }
    }

    @Override
    public void delete(Object rootId, PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        RelationalPersistentEntity rootEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(((RelationalPersistentProperty)propertyPath.getBaseProperty()).getOwner().getType());
        RelationalPersistentProperty referencingProperty = (RelationalPersistentProperty)propertyPath.getLeafProperty();
        Assert.notNull((Object)referencingProperty, (String)("No property found matching the PropertyPath " + propertyPath));
        String delete = this.sql(rootEntity.getType()).createDeleteByPath(propertyPath);
        SqlIdentifierParameterSource parameters = new SqlIdentifierParameterSource(this.getIdentifierProcessing());
        this.addConvertedPropertyValue(parameters, (RelationalPersistentProperty)rootEntity.getRequiredIdProperty(), rootId, SqlGenerator.ROOT_ID_PARAMETER);
        this.operations.update(delete, (SqlParameterSource)parameters);
    }

    @Override
    public <T> void deleteAll(Class<T> domainType) {
        this.operations.getJdbcOperations().update(this.sql(domainType).createDeleteAllSql(null));
    }

    @Override
    public void deleteAll(PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
        this.operations.getJdbcOperations().update(this.sql(((RelationalPersistentProperty)propertyPath.getBaseProperty()).getOwner().getType()).createDeleteAllSql(propertyPath));
    }

    @Override
    public <T> void acquireLockById(Object id, LockMode lockMode, Class<T> domainType) {
        String acquireLockByIdSql = this.sql(domainType).getAcquireLockById(lockMode);
        SqlIdentifierParameterSource parameter = this.createIdParameterSource(id, domainType);
        this.operations.query(acquireLockByIdSql, (SqlParameterSource)parameter, ResultSet::next);
    }

    @Override
    public <T> void acquireLockAll(LockMode lockMode, Class<T> domainType) {
        String acquireLockAllSql = this.sql(domainType).getAcquireLockAll(lockMode);
        this.operations.getJdbcOperations().query(acquireLockAllSql, ResultSet::next);
    }

    @Override
    public long count(Class<?> domainType) {
        Long result = (Long)this.operations.getJdbcOperations().queryForObject(this.sql(domainType).getCount(), Long.class);
        Assert.notNull((Object)result, (String)"The result of a count query must not be null.");
        return result;
    }

    @Override
    public <T> T findById(Object id, Class<T> domainType) {
        String findOneSql = this.sql(domainType).getFindOne();
        SqlIdentifierParameterSource parameter = this.createIdParameterSource(id, domainType);
        try {
            return (T)this.operations.queryForObject(findOneSql, (SqlParameterSource)parameter, this.getEntityRowMapper(domainType));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType) {
        return this.operations.query(this.sql(domainType).getFindAll(), this.getEntityRowMapper(domainType));
    }

    @Override
    public <T> Iterable<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        if (!ids.iterator().hasNext()) {
            return Collections.emptyList();
        }
        RelationalPersistentProperty idProperty = (RelationalPersistentProperty)this.getRequiredPersistentEntity(domainType).getRequiredIdProperty();
        SqlIdentifierParameterSource parameterSource = new SqlIdentifierParameterSource(this.getIdentifierProcessing());
        this.addConvertedPropertyValuesAsList(parameterSource, idProperty, ids, SqlGenerator.IDS_SQL_PARAMETER);
        String findAllInListSql = this.sql(domainType).getFindAllInList();
        return this.operations.query(findAllInListSql, (SqlParameterSource)parameterSource, this.getEntityRowMapper(domainType));
    }

    @Override
    public Iterable<Object> findAllByPath(Identifier identifier, PersistentPropertyPath<? extends RelationalPersistentProperty> propertyPath) {
        Assert.notNull((Object)identifier, (String)"identifier must not be null.");
        Assert.notNull(propertyPath, (String)"propertyPath must not be null.");
        PersistentPropertyPathExtension path = new PersistentPropertyPathExtension((MappingContext)this.context, propertyPath);
        Class actualType = path.getActualType();
        String findAllByProperty = this.sql(actualType).getFindAllByProperty(identifier, path.getQualifierColumn(), path.isOrdered());
        RowMapper<?> rowMapper = path.isMap() ? this.getMapEntityRowMapper(path, identifier) : this.getEntityRowMapper(path, identifier);
        return this.operations.query(findAllByProperty, this.createParameterSource(identifier, this.getIdentifierProcessing()), rowMapper);
    }

    private SqlParameterSource createParameterSource(Identifier identifier, IdentifierProcessing identifierProcessing) {
        SqlIdentifierParameterSource parameterSource = new SqlIdentifierParameterSource(identifierProcessing);
        identifier.toMap().forEach((name, value) -> this.addConvertedPropertyValue(parameterSource, (SqlIdentifier)name, value, value.getClass()));
        return parameterSource;
    }

    @Override
    public <T> boolean existsById(Object id, Class<T> domainType) {
        SqlIdentifierParameterSource parameter;
        String existsSql = this.sql(domainType).getExists();
        Boolean result = (Boolean)this.operations.queryForObject(existsSql, (SqlParameterSource)(parameter = this.createIdParameterSource(id, domainType)), Boolean.class);
        Assert.state((result != null ? 1 : 0) != 0, (String)"The result of an exists query must not be null");
        return result;
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType, Sort sort) {
        return this.operations.query(this.sql(domainType).getFindAll(sort), this.getEntityRowMapper(domainType));
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType, Pageable pageable) {
        return this.operations.query(this.sql(domainType).getFindAll(pageable), this.getEntityRowMapper(domainType));
    }

    private <S, T> SqlIdentifierParameterSource getParameterSource(@Nullable S instance, RelationalPersistentEntity<S> persistentEntity, String prefix, Predicate<RelationalPersistentProperty> skipProperty, IdentifierProcessing identifierProcessing) {
        SqlIdentifierParameterSource parameters = new SqlIdentifierParameterSource(identifierProcessing);
        PersistentPropertyAccessor propertyAccessor = instance != null ? persistentEntity.getPropertyAccessor(instance) : NoValuePropertyAccessor.instance();
        persistentEntity.doWithProperties(property -> {
            if (skipProperty.test((RelationalPersistentProperty)property) || !property.isWritable()) {
                return;
            }
            if (property.isEntity() && !property.isEmbedded()) {
                return;
            }
            if (property.isEmbedded()) {
                Object value = propertyAccessor.getProperty(property);
                RelationalPersistentEntity embeddedEntity = (RelationalPersistentEntity)this.context.getPersistentEntity(property.getType());
                SqlIdentifierParameterSource additionalParameters = this.getParameterSource(value, embeddedEntity, prefix + property.getEmbeddedPrefix(), skipProperty, identifierProcessing);
                parameters.addAll(additionalParameters);
            } else {
                Object value = propertyAccessor.getProperty(property);
                SqlIdentifier paramName = property.getColumnName().transform(prefix::concat);
                this.addConvertedPropertyValue(parameters, (RelationalPersistentProperty)property, value, paramName);
            }
        });
        return parameters;
    }

    @Nullable
    private <S, ID> ID getIdValueOrNull(S instance, RelationalPersistentEntity<S> persistentEntity) {
        Object idValue = persistentEntity.getIdentifierAccessor(instance).getIdentifier();
        return (ID)(DefaultDataAccessStrategy.isIdPropertyNullOrScalarZero(idValue, persistentEntity) ? null : idValue);
    }

    private static <S, ID> boolean isIdPropertyNullOrScalarZero(@Nullable ID idValue, RelationalPersistentEntity<S> persistentEntity) {
        RelationalPersistentProperty idProperty = (RelationalPersistentProperty)persistentEntity.getIdProperty();
        return idValue == null || idProperty == null || idProperty.getType() == Integer.TYPE && idValue.equals(0) || idProperty.getType() == Long.TYPE && idValue.equals(0L);
    }

    @Nullable
    private <S> Object getIdFromHolder(KeyHolder holder, RelationalPersistentEntity<S> persistentEntity) {
        try {
            return holder.getKey();
        }
        catch (DataRetrievalFailureException | InvalidDataAccessApiUsageException e) {
            Map keys = holder.getKeys();
            if (keys == null || persistentEntity.getIdProperty() == null) {
                return null;
            }
            return keys.get(persistentEntity.getIdColumn().getReference(this.getIdentifierProcessing()));
        }
    }

    private EntityRowMapper<?> getEntityRowMapper(Class<?> domainType) {
        return new EntityRowMapper(this.getRequiredPersistentEntity(domainType), this.converter);
    }

    private EntityRowMapper<?> getEntityRowMapper(PersistentPropertyPathExtension path, Identifier identifier) {
        return new EntityRowMapper(path, this.converter, identifier);
    }

    private RowMapper<?> getMapEntityRowMapper(PersistentPropertyPathExtension path, Identifier identifier) {
        SqlIdentifier keyColumn = path.getQualifierColumn();
        Assert.notNull((Object)keyColumn, () -> "KeyColumn must not be null for " + path);
        return new MapEntityRowMapper(path, this.converter, identifier, keyColumn, this.getIdentifierProcessing());
    }

    private <T> SqlIdentifierParameterSource createIdParameterSource(Object id, Class<T> domainType) {
        SqlIdentifierParameterSource parameterSource = new SqlIdentifierParameterSource(this.getIdentifierProcessing());
        this.addConvertedPropertyValue(parameterSource, (RelationalPersistentProperty)this.getRequiredPersistentEntity(domainType).getRequiredIdProperty(), id, SqlGenerator.ID_SQL_PARAMETER);
        return parameterSource;
    }

    private IdentifierProcessing getIdentifierProcessing() {
        return this.sqlGeneratorSource.getDialect().getIdentifierProcessing();
    }

    private void addConvertedPropertyValue(SqlIdentifierParameterSource parameterSource, RelationalPersistentProperty property, @Nullable Object value, SqlIdentifier name) {
        this.addConvertedValue(parameterSource, value, name, this.converter.getColumnType(property), this.converter.getSqlType(property));
    }

    private void addConvertedPropertyValue(SqlIdentifierParameterSource parameterSource, SqlIdentifier name, Object value, Class<?> javaType) {
        this.addConvertedValue(parameterSource, value, name, javaType, JdbcUtil.sqlTypeFor(javaType));
    }

    private void addConvertedValue(SqlIdentifierParameterSource parameterSource, @Nullable Object value, SqlIdentifier paramName, Class<?> javaType, int sqlType) {
        JdbcValue jdbcValue = this.converter.writeJdbcValue(value, javaType, sqlType);
        parameterSource.addValue(paramName, jdbcValue.getValue(), JdbcUtil.sqlTypeFor(jdbcValue.getJdbcType()));
    }

    private void addConvertedPropertyValuesAsList(SqlIdentifierParameterSource parameterSource, RelationalPersistentProperty property, Iterable<?> values, SqlIdentifier paramName) {
        ArrayList<Object> convertedIds = new ArrayList<Object>();
        JdbcValue jdbcValue = null;
        for (Object id : values) {
            Class<?> columnType = this.converter.getColumnType(property);
            int sqlType = this.converter.getSqlType(property);
            jdbcValue = this.converter.writeJdbcValue(id, columnType, sqlType);
            convertedIds.add(jdbcValue.getValue());
        }
        Assert.state((jdbcValue != null ? 1 : 0) != 0, (String)"JdbcValue must be not null at this point. Please report this as a bug.");
        JDBCType jdbcType = jdbcValue.getJdbcType();
        int typeNumber = jdbcType == null ? Integer.MIN_VALUE : jdbcType.getVendorTypeNumber();
        parameterSource.addValue(paramName, convertedIds, typeNumber);
    }

    private <S> RelationalPersistentEntity<S> getRequiredPersistentEntity(Class<S> domainType) {
        return (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType);
    }

    private SqlGenerator sql(Class<?> domainType) {
        return this.sqlGeneratorSource.getSqlGenerator(domainType);
    }

    private <T> String[] getKeyColumnNames(Class<T> domainType) {
        RelationalPersistentEntity requiredPersistentEntity = (RelationalPersistentEntity)this.context.getRequiredPersistentEntity(domainType);
        if (!requiredPersistentEntity.hasIdProperty()) {
            return new String[0];
        }
        SqlIdentifier idColumn = requiredPersistentEntity.getIdColumn();
        return new String[]{idColumn.getReference(this.getIdentifierProcessing())};
    }

    static class NoValuePropertyAccessor<T>
    implements PersistentPropertyAccessor<T> {
        private static final NoValuePropertyAccessor INSTANCE = new NoValuePropertyAccessor();

        NoValuePropertyAccessor() {
        }

        static <T> NoValuePropertyAccessor<T> instance() {
            return INSTANCE;
        }

        public void setProperty(PersistentProperty<?> property, @Nullable Object value) {
            throw new UnsupportedOperationException("Cannot set value on 'null' target object.");
        }

        public Object getProperty(PersistentProperty<?> property) {
            return null;
        }

        public T getBean() {
            return null;
        }
    }

    static class Predicates {
        Predicates() {
        }

        static Predicate<RelationalPersistentProperty> includeAll() {
            return it -> false;
        }
    }
}

