/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.Collections;
import java.util.Optional;
import org.springframework.data.jdbc.core.convert.DataAccessStrategy;
import org.springframework.data.jdbc.core.convert.DelegatingDataAccessStrategy;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.SingleQueryDataAccessStrategy;
import org.springframework.data.jdbc.core.convert.SqlGeneratorSource;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.query.Query;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.util.Assert;

class SingleQueryFallbackDataAccessStrategy
extends DelegatingDataAccessStrategy {
    private final SqlGeneratorSource sqlGeneratorSource;
    private final SingleQueryDataAccessStrategy singleSelectDelegate;
    private final JdbcConverter converter;

    public SingleQueryFallbackDataAccessStrategy(SqlGeneratorSource sqlGeneratorSource, JdbcConverter converter, NamedParameterJdbcOperations operations, DataAccessStrategy fallback) {
        super(fallback);
        Assert.notNull((Object)sqlGeneratorSource, (String)"SqlGeneratorSource must not be null");
        Assert.notNull((Object)converter, (String)"JdbcConverter must not be null");
        Assert.notNull((Object)operations, (String)"NamedParameterJdbcOperations must not be null");
        this.sqlGeneratorSource = sqlGeneratorSource;
        this.converter = converter;
        this.singleSelectDelegate = new SingleQueryDataAccessStrategy(sqlGeneratorSource.getDialect(), converter, operations);
    }

    @Override
    public <T> T findById(Object id, Class<T> domainType) {
        if (this.isSingleSelectQuerySupported(domainType)) {
            return this.singleSelectDelegate.findById(id, domainType);
        }
        return super.findById(id, domainType);
    }

    @Override
    public <T> Iterable<T> findAll(Class<T> domainType) {
        if (this.isSingleSelectQuerySupported(domainType)) {
            return this.singleSelectDelegate.findAll((Class)domainType);
        }
        return super.findAll(domainType);
    }

    @Override
    public <T> Iterable<T> findAllById(Iterable<?> ids, Class<T> domainType) {
        if (!ids.iterator().hasNext()) {
            return Collections.emptyList();
        }
        if (this.isSingleSelectQuerySupported(domainType)) {
            return this.singleSelectDelegate.findAllById((Iterable)ids, (Class)domainType);
        }
        return super.findAllById(ids, domainType);
    }

    @Override
    public <T> Optional<T> findOne(Query query, Class<T> domainType) {
        if (this.isSingleSelectQuerySupported(domainType) && SingleQueryFallbackDataAccessStrategy.isSingleSelectQuerySupported(query)) {
            return this.singleSelectDelegate.findOne(query, domainType);
        }
        return super.findOne(query, domainType);
    }

    @Override
    public <T> Iterable<T> findAll(Query query, Class<T> domainType) {
        if (this.isSingleSelectQuerySupported(domainType) && SingleQueryFallbackDataAccessStrategy.isSingleSelectQuerySupported(query)) {
            return this.singleSelectDelegate.findAll(query, (Class)domainType);
        }
        return super.findAll(query, domainType);
    }

    private static boolean isSingleSelectQuerySupported(Query query) {
        return !query.isSorted() && !query.isLimited();
    }

    private boolean isSingleSelectQuerySupported(Class<?> entityType) {
        return this.converter.getMappingContext().isSingleQueryLoadingEnabled() && this.sqlGeneratorSource.getDialect().supportsSingleQueryLoading() && this.entityQualifiesForSingleQueryLoading(entityType);
    }

    private boolean entityQualifiesForSingleQueryLoading(Class<?> entityType) {
        for (PersistentPropertyPath path : this.converter.getMappingContext().findPersistentPropertyPaths(entityType, __ -> true)) {
            RelationalPersistentProperty property = (RelationalPersistentProperty)path.getLeafProperty();
            if (!property.isEntity()) continue;
            if (!property.isMap() && !property.isCollectionLike()) {
                return false;
            }
            if (property.isEmbedded()) {
                return false;
            }
            if (path.getLength() <= 1) continue;
            return false;
        }
        return true;
    }
}

