/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import org.springframework.util.Assert;

final class ArrayUtils {
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final Float[] EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];

    private ArrayUtils() {
    }

    static boolean[] toPrimitive(Boolean[] array) {
        Assert.noNullElements((Object[])array, (String)"Array must not contain null elements");
        if (array.length == 0) {
            return EMPTY_BOOLEAN_ARRAY;
        }
        boolean[] booleans = new boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            booleans[i] = array[i];
        }
        return booleans;
    }

    static Boolean[] toObject(boolean[] array) {
        if (array.length == 0) {
            return EMPTY_BOOLEAN_OBJECT_ARRAY;
        }
        Boolean[] booleans = new Boolean[array.length];
        for (int i = 0; i < array.length; ++i) {
            booleans[i] = array[i];
        }
        return booleans;
    }

    static byte[] toPrimitive(Byte[] array) {
        Assert.noNullElements((Object[])array, (String)"Array must not contain null elements");
        if (array.length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            bytes[i] = array[i];
        }
        return bytes;
    }

    static Byte[] toObject(byte[] array) {
        if (array.length == 0) {
            return EMPTY_BYTE_OBJECT_ARRAY;
        }
        Byte[] bytes = new Byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            bytes[i] = array[i];
        }
        return bytes;
    }

    static char[] toPrimitive(Character[] array) {
        Assert.noNullElements((Object[])array, (String)"Array must not contain null elements");
        if (array.length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] chars = new char[array.length];
        for (int i = 0; i < array.length; ++i) {
            chars[i] = array[i].charValue();
        }
        return chars;
    }

    static Character[] toObject(char[] array) {
        if (array.length == 0) {
            return EMPTY_CHARACTER_OBJECT_ARRAY;
        }
        Character[] objects = new Character[array.length];
        for (int i = 0; i < array.length; ++i) {
            objects[i] = Character.valueOf(array[i]);
        }
        return objects;
    }

    static double[] toPrimitive(Double[] array) {
        Assert.noNullElements((Object[])array, (String)"Array must not contain null elements");
        if (array.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] doubles = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            doubles[i] = array[i];
        }
        return doubles;
    }

    static Double[] toObject(double[] array) {
        if (array.length == 0) {
            return EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        Double[] objects = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            objects[i] = array[i];
        }
        return objects;
    }

    static float[] toPrimitive(Float[] array) {
        Assert.noNullElements((Object[])array, (String)"Array must not contain null elements");
        if (array.length == 0) {
            return EMPTY_FLOAT_ARRAY;
        }
        float[] floats = new float[array.length];
        for (int i = 0; i < array.length; ++i) {
            floats[i] = array[i].floatValue();
        }
        return floats;
    }

    static Float[] toObject(float[] array) {
        if (array.length == 0) {
            return EMPTY_FLOAT_OBJECT_ARRAY;
        }
        Float[] objects = new Float[array.length];
        for (int i = 0; i < array.length; ++i) {
            objects[i] = Float.valueOf(array[i]);
        }
        return objects;
    }

    static int[] toPrimitive(Integer[] array) {
        Assert.noNullElements((Object[])array, (String)"Array must not contain null elements");
        if (array.length == 0) {
            return EMPTY_INT_ARRAY;
        }
        int[] ints = new int[array.length];
        for (int i = 0; i < array.length; ++i) {
            ints[i] = array[i];
        }
        return ints;
    }

    static Integer[] toObject(int[] array) {
        if (array.length == 0) {
            return EMPTY_INTEGER_OBJECT_ARRAY;
        }
        Integer[] objects = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            objects[i] = array[i];
        }
        return objects;
    }

    static long[] toPrimitive(Long[] array) {
        Assert.noNullElements((Object[])array, (String)"Array must not contain null elements");
        if (array.length == 0) {
            return EMPTY_LONG_ARRAY;
        }
        long[] longs = new long[array.length];
        for (int i = 0; i < array.length; ++i) {
            longs[i] = array[i];
        }
        return longs;
    }

    static Long[] toObject(long[] array) {
        if (array.length == 0) {
            return EMPTY_LONG_OBJECT_ARRAY;
        }
        Long[] objects = new Long[array.length];
        for (int i = 0; i < array.length; ++i) {
            objects[i] = array[i];
        }
        return objects;
    }

    static short[] toPrimitive(Short[] array) {
        Assert.noNullElements((Object[])array, (String)"Array must not contain null elements");
        if (array.length == 0) {
            return EMPTY_SHORT_ARRAY;
        }
        short[] shorts = new short[array.length];
        for (int i = 0; i < array.length; ++i) {
            shorts[i] = array[i];
        }
        return shorts;
    }

    static Short[] toObject(short[] array) {
        if (array.length == 0) {
            return EMPTY_SHORT_OBJECT_ARRAY;
        }
        Short[] objects = new Short[array.length];
        for (int i = 0; i < array.length; ++i) {
            objects[i] = array[i];
        }
        return objects;
    }
}

