/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractMap;
import java.util.Map;
import org.springframework.data.jdbc.core.convert.Identifier;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.RowDocumentResultSetExtractor;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.domain.RowDocument;
import org.springframework.data.util.TypeInformation;
import org.springframework.jdbc.core.RowMapper;

class MapEntityRowMapper<T>
implements RowMapper<Map.Entry<Object, T>> {
    private final AggregatePath path;
    private final JdbcConverter converter;
    private final Identifier identifier;
    private final SqlIdentifier keyColumn;

    MapEntityRowMapper(AggregatePath path, JdbcConverter converter, Identifier identifier, SqlIdentifier keyColumn) {
        this.path = path;
        this.converter = converter;
        this.identifier = identifier;
        this.keyColumn = keyColumn;
    }

    public Map.Entry<Object, T> mapRow(ResultSet rs, int rowNum) throws SQLException {
        RowDocument document = RowDocumentResultSetExtractor.toRowDocument(rs);
        Object key = document.get((Object)this.keyColumn.getReference());
        Class qualifierColumnType = this.path.getRequiredLeafProperty().getQualifierColumnType();
        Object convertedKey = this.converter.readValue(key, TypeInformation.of((Class)qualifierColumnType));
        return new AbstractMap.SimpleEntry<Object, T>(convertedKey, this.mapEntity(document, key));
    }

    private T mapEntity(RowDocument document, Object key) {
        return (T)this.converter.readAndResolve(this.path.getRequiredLeafEntity().getTypeInformation(), document, this.identifier.withPart(this.keyColumn, key, Object.class));
    }
}

