/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.repository.query;

import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.core.convert.QueryMapper;
import org.springframework.data.jdbc.core.convert.SqlGeneratorSource;
import org.springframework.data.jdbc.repository.query.ParametrizedQuery;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.dialect.RenderContextFactory;
import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.RelationalMappingContext;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.query.Criteria;
import org.springframework.data.relational.core.query.CriteriaDefinition;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Expressions;
import org.springframework.data.relational.core.sql.Functions;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.SelectBuilder;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.SqlRenderer;
import org.springframework.data.relational.repository.Lock;
import org.springframework.data.relational.repository.query.RelationalEntityMetadata;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.relational.repository.query.RelationalQueryCreator;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class JdbcQueryCreator
extends RelationalQueryCreator<ParametrizedQuery> {
    private final RelationalMappingContext context;
    private final PartTree tree;
    private final RelationalParameterAccessor accessor;
    private final QueryMapper queryMapper;
    private final RelationalEntityMetadata<?> entityMetadata;
    private final RenderContextFactory renderContextFactory;
    private final boolean isSliceQuery;
    private final ReturnedType returnedType;
    private final Optional<Lock> lockMode;
    private final SqlGeneratorSource sqlGeneratorSource;

    @Deprecated(since="4.0", forRemoval=true)
    JdbcQueryCreator(RelationalMappingContext context, PartTree tree, JdbcConverter converter, Dialect dialect, RelationalEntityMetadata<?> entityMetadata, RelationalParameterAccessor accessor, boolean isSliceQuery, ReturnedType returnedType, Optional<Lock> lockMode) {
        this(context, tree, converter, dialect, entityMetadata, accessor, isSliceQuery, returnedType, lockMode, new SqlGeneratorSource(context, converter, dialect));
    }

    JdbcQueryCreator(RelationalMappingContext context, PartTree tree, JdbcConverter converter, Dialect dialect, RelationalEntityMetadata<?> entityMetadata, RelationalParameterAccessor accessor, boolean isSliceQuery, ReturnedType returnedType, Optional<Lock> lockMode, SqlGeneratorSource sqlGeneratorSource) {
        super(tree, accessor);
        Assert.notNull((Object)converter, (String)"JdbcConverter must not be null");
        Assert.notNull((Object)dialect, (String)"Dialect must not be null");
        Assert.notNull(entityMetadata, (String)"Relational entity metadata must not be null");
        Assert.notNull((Object)returnedType, (String)"ReturnedType must not be null");
        Assert.notNull((Object)sqlGeneratorSource, (String)"SqlGeneratorSource must not be null");
        this.context = context;
        this.tree = tree;
        this.accessor = accessor;
        this.entityMetadata = entityMetadata;
        this.queryMapper = new QueryMapper(converter);
        this.renderContextFactory = new RenderContextFactory(dialect);
        this.isSliceQuery = isSliceQuery;
        this.returnedType = returnedType;
        this.lockMode = lockMode;
        this.sqlGeneratorSource = sqlGeneratorSource;
    }

    static void validate(PartTree tree, Parameters<?, ?> parameters, RelationalMappingContext context) {
        RelationalQueryCreator.validate((PartTree)tree, parameters);
        for (PartTree.OrPart parts : tree) {
            for (Part part : parts) {
                PersistentPropertyPath propertyPath = context.getPersistentPropertyPath(part.getProperty());
                AggregatePath path = context.getAggregatePath(propertyPath);
                path.forEach(JdbcQueryCreator::validateProperty);
            }
        }
    }

    private static void validateProperty(AggregatePath path) {
        if (path.isRoot()) {
            return;
        }
        if (!path.getParentPath().isEmbedded() && path.getLength() > 2) {
            throw new IllegalArgumentException(String.format("Cannot query by nested property: %s", path.toDotPath()));
        }
        if (path.isMultiValued() || path.isMap()) {
            throw new IllegalArgumentException(String.format("Cannot query by multi-valued property: %s", path.getRequiredLeafProperty().getName()));
        }
        if (!path.isEmbedded() && path.isEntity()) {
            throw new IllegalArgumentException(String.format("Cannot query by nested entity: %s", path.toDotPath()));
        }
    }

    protected ParametrizedQuery complete(@Nullable Criteria criteria, Sort sort) {
        RelationalPersistentEntity entity = this.entityMetadata.getTableEntity();
        Table table = Table.create((SqlIdentifier)this.entityMetadata.getTableName());
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        SelectBuilder.SelectLimitOffset limitOffsetBuilder = this.createSelectClause(entity, table);
        SelectBuilder.SelectWhere whereBuilder = this.applyLimitAndOffset(limitOffsetBuilder);
        SelectBuilder.SelectOrdered selectOrderBuilder = this.applyCriteria(criteria, entity, table, parameterSource, whereBuilder);
        SelectBuilder.SelectOrdered completedBuildSelect = selectOrderBuilder = this.applyOrderBy(sort, entity, table, selectOrderBuilder);
        if (this.lockMode.isPresent()) {
            completedBuildSelect = selectOrderBuilder.lock(this.lockMode.get().value());
        }
        Select select = completedBuildSelect.build();
        String sql = SqlRenderer.create((RenderContext)this.renderContextFactory.createRenderContext()).render(select);
        return new ParametrizedQuery(sql, (SqlParameterSource)parameterSource);
    }

    SelectBuilder.SelectOrdered applyOrderBy(Sort sort, RelationalPersistentEntity<?> entity, Table table, SelectBuilder.SelectOrdered selectOrdered) {
        return sort.isSorted() ? selectOrdered.orderBy(this.queryMapper.getMappedSort(table, sort, entity)) : selectOrdered;
    }

    SelectBuilder.SelectOrdered applyCriteria(@Nullable Criteria criteria, RelationalPersistentEntity<?> entity, Table table, MapSqlParameterSource parameterSource, SelectBuilder.SelectWhere whereBuilder) {
        return criteria != null ? whereBuilder.where(this.queryMapper.getMappedObject(parameterSource, (CriteriaDefinition)criteria, table, entity)) : whereBuilder;
    }

    SelectBuilder.SelectWhere applyLimitAndOffset(SelectBuilder.SelectLimitOffset limitOffsetBuilder) {
        if (this.tree.isExistsProjection()) {
            limitOffsetBuilder = limitOffsetBuilder.limit(1L);
        } else if (this.tree.isLimiting()) {
            limitOffsetBuilder = limitOffsetBuilder.limit((long)this.tree.getMaxResults().intValue());
        }
        Pageable pageable = this.accessor.getPageable();
        if (pageable.isPaged()) {
            limitOffsetBuilder = limitOffsetBuilder.limit(this.isSliceQuery ? (long)(pageable.getPageSize() + 1) : (long)pageable.getPageSize()).offset(pageable.getOffset());
        }
        return (SelectBuilder.SelectWhere)limitOffsetBuilder;
    }

    SelectBuilder.SelectLimitOffset createSelectClause(RelationalPersistentEntity<?> entity, Table table) {
        Object builder;
        if (this.tree.isExistsProjection()) {
            AggregatePath.ColumnInfo anyIdColumnInfo = this.context.getAggregatePath(entity).getTableInfo().idColumnInfos().any();
            Column idColumn = table.column(anyIdColumnInfo.name());
            builder = Select.builder().select((Expression)idColumn).from((TableLike)table);
        } else {
            builder = this.tree.isCountProjection() ? Select.builder().select((Expression)Functions.count((Expression[])new Expression[]{Expressions.asterisk()})).from((TableLike)table) : this.selectBuilder(table);
        }
        return (SelectBuilder.SelectLimitOffset)builder;
    }

    private SelectBuilder.SelectJoin selectBuilder(Table table) {
        RelationalPersistentEntity entity = this.entityMetadata.getTableEntity();
        Predicate<AggregatePath> filter = ap -> this.returnedType.needsCustomConstruction() && !this.returnedType.getInputProperties().contains(ap.getRequiredBaseProperty().getName());
        return (SelectBuilder.SelectJoin)this.sqlGeneratorSource.getSqlGenerator(entity.getType()).createSelectBuilder(table, filter);
    }
}

