/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import org.springframework.data.relational.core.mapping.AggregatePath;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.relational.core.sql.Table;

class SqlContext {
    private final RelationalPersistentEntity<?> entity;
    private final Table table;

    SqlContext(RelationalPersistentEntity<?> entity) {
        this.entity = entity;
        this.table = Table.create((SqlIdentifier)entity.getQualifiedTableName());
    }

    Column getVersionColumn() {
        return this.table.column(((RelationalPersistentProperty)this.entity.getRequiredVersionProperty()).getColumnName());
    }

    Table getTable() {
        return this.table;
    }

    Table getTable(AggregatePath path) {
        SqlIdentifier tableAlias = path.getTableInfo().tableAlias();
        Table table = Table.create((SqlIdentifier)path.getTableInfo().qualifiedTableName());
        return tableAlias == null ? table : table.as(tableAlias);
    }

    Column getColumn(AggregatePath path) {
        return this.getAliasedColumn(path, path.getColumnInfo());
    }

    Column getAnyReverseColumn(AggregatePath path) {
        return this.getAliasedColumn(path, path.getTableInfo().backReferenceColumnInfos().any());
    }

    private Column getAliasedColumn(AggregatePath path, AggregatePath.ColumnInfo columnInfo) {
        return this.getTable(path).column(columnInfo.name()).as(columnInfo.alias());
    }
}

