/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.ParameterExpression;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.CriteriaQueryParameterBinder;
import org.springframework.data.jpa.repository.query.JpaCountQueryCreator;
import org.springframework.data.jpa.repository.query.JpaQueryCreator;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.ParameterBinder;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.Assert;

public class PartTreeJpaQuery
extends AbstractJpaQuery {
    private final Class<?> domainClass;
    private final PartTree tree;
    private final Parameters parameters;
    private final QueryPreparer query;
    private final QueryPreparer countQuery;

    public PartTreeJpaQuery(JpaQueryMethod method, EntityManager em) {
        super(method, em);
        this.domainClass = method.getEntityInformation().getJavaType();
        this.tree = new PartTree(method.getName(), this.domainClass);
        this.parameters = method.getParameters();
        this.query = new QueryPreparer(this.tree, this.domainClass, this.parameters);
        this.countQuery = new CountQueryPreparer(this.tree, this.domainClass, this.parameters);
    }

    public Query createQuery(Object[] values) {
        return this.query.createQuery(values);
    }

    public Query createCountQuery(Object[] values) {
        return this.countQuery.createQuery(values);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CountQueryPreparer
    extends QueryPreparer {
        public CountQueryPreparer(PartTree tree, Class<?> domainClass, Parameters parameters) {
            super(new JpaCountQueryCreator(tree, domainClass, parameters, PartTreeJpaQuery.this.getEntityManager()));
        }

        @Override
        protected Query invokeBinding(ParameterBinder binder, TypedQuery<?> query) {
            return binder.bind((Query)query);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QueryPreparer {
        private CriteriaQuery<?> query;
        private final JpaQueryCreator creator;

        public QueryPreparer(PartTree tree, Class<?> domainClass, Parameters parameters) {
            this(new JpaQueryCreator(tree, domainClass, parameters, partTreeJpaQuery.getEntityManager()));
        }

        protected QueryPreparer(JpaQueryCreator creator) {
            Assert.notNull((Object)((Object)creator));
            this.creator = creator;
            this.query = null;
        }

        public Query createQuery(Object[] values) {
            if (PartTreeJpaQuery.this.parameters.potentiallySortsDynamically() || this.query == null) {
                this.query = (CriteriaQuery)this.creator.createQuery(this.getDynamicSort(values));
            }
            TypedQuery jpaQuery = PartTreeJpaQuery.this.getEntityManager().createQuery(this.query);
            return this.invokeBinding(this.getBinder(values, this.creator.getParameterExpressions()), jpaQuery);
        }

        protected Query invokeBinding(ParameterBinder binder, TypedQuery<?> query) {
            return binder.bindAndPrepare((Query)query);
        }

        private ParameterBinder getBinder(Object[] values, List<ParameterExpression<?>> expressions) {
            return new CriteriaQueryParameterBinder(PartTreeJpaQuery.this.parameters, values, expressions);
        }

        private Sort getDynamicSort(Object[] values) {
            return PartTreeJpaQuery.this.parameters.hasSortParameter() ? new ParametersParameterAccessor(PartTreeJpaQuery.this.parameters, values).getSort() : null;
        }
    }
}

