/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.JpaEntityInformationSupport;
import org.springframework.data.jpa.repository.support.PersistenceProvider;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
@Transactional(readOnly=true)
public class SimpleJpaRepository<T, ID extends Serializable>
implements JpaRepository<T, ID>,
JpaSpecificationExecutor<T> {
    private final JpaEntityInformation<T, ?> entityInformation;
    private final EntityManager em;
    private final PersistenceProvider provider;

    public SimpleJpaRepository(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        Assert.notNull(entityInformation);
        Assert.notNull((Object)entityManager);
        this.entityInformation = entityInformation;
        this.em = entityManager;
        this.provider = PersistenceProvider.fromEntityManager(entityManager);
    }

    public SimpleJpaRepository(Class<T> domainClass, EntityManager em) {
        this(JpaEntityInformationSupport.getMetadata(domainClass, em), em);
    }

    private Class<T> getDomainClass() {
        return this.entityInformation.getJavaType();
    }

    private String getDeleteAllQueryString() {
        return QueryUtils.getQueryString("delete from %s x", this.entityInformation.getEntityName());
    }

    private String getCountQueryString() {
        String countQuery = String.format("select count(%s) from %s x", this.provider.getCountQueryPlaceholder(), "%s");
        return QueryUtils.getQueryString(countQuery, this.entityInformation.getEntityName());
    }

    @Transactional
    public void delete(ID id) {
        this.delete(this.findOne(id));
    }

    @Transactional
    public void delete(T entity) {
        this.em.remove(this.em.contains(entity) ? entity : this.em.merge(entity));
    }

    @Transactional
    public void delete(Iterable<? extends T> entities) {
        if (entities == null) {
            return;
        }
        for (T entity : entities) {
            this.delete(entity);
        }
    }

    @Override
    @Transactional
    public void deleteInBatch(Iterable<T> entities) {
        if (null == entities || !entities.iterator().hasNext()) {
            return;
        }
        QueryUtils.applyAndBind(QueryUtils.getQueryString("delete from %s x", this.entityInformation.getEntityName()), entities, this.em).executeUpdate();
        this.em.clear();
    }

    @Transactional
    public void deleteAll() {
        this.em.createQuery(this.getDeleteAllQueryString()).executeUpdate();
        this.em.clear();
    }

    public T findOne(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return (T)this.em.find(this.getDomainClass(), id);
    }

    public boolean exists(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return null != this.findOne(id);
    }

    @Override
    public List<T> findAll() {
        return this.getQuery(null, (Sort)null).getResultList();
    }

    @Override
    public List<T> findAll(Sort sort) {
        return this.getQuery(null, sort).getResultList();
    }

    public Page<T> findAll(Pageable pageable) {
        if (null == pageable) {
            return new PageImpl((List)this.findAll());
        }
        return this.findAll(null, pageable);
    }

    @Override
    public T findOne(Specification<T> spec) {
        try {
            return (T)this.getQuery(spec, (Sort)null).getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    @Override
    public List<T> findAll(Specification<T> spec) {
        return this.getQuery(spec, (Sort)null).getResultList();
    }

    @Override
    public Page<T> findAll(Specification<T> spec, Pageable pageable) {
        TypedQuery<T> query = this.getQuery(spec, pageable);
        return pageable == null ? new Page<T>(query.getResultList()) : this.readPage(query, pageable, spec);
    }

    @Override
    public List<T> findAll(Specification<T> spec, Sort sort) {
        return this.getQuery(spec, sort).getResultList();
    }

    public long count() {
        return (Long)this.em.createQuery(this.getCountQueryString(), Long.class).getSingleResult();
    }

    @Override
    public long count(Specification<T> spec) {
        return (Long)this.getCountQuery(spec).getSingleResult();
    }

    @Transactional
    public T save(T entity) {
        if (this.entityInformation.isNew(entity)) {
            this.em.persist(entity);
            return entity;
        }
        return (T)this.em.merge(entity);
    }

    @Override
    @Transactional
    public T saveAndFlush(T entity) {
        T result = this.save(entity);
        this.flush();
        return result;
    }

    @Override
    @Transactional
    public List<T> save(Iterable<? extends T> entities) {
        ArrayList<T> result = new ArrayList<T>();
        if (entities == null) {
            return result;
        }
        for (T entity : entities) {
            result.add(this.save(entity));
        }
        return result;
    }

    @Override
    @Transactional
    public void flush() {
        this.em.flush();
    }

    private Page<T> readPage(TypedQuery<T> query, Pageable pageable, Specification<T> spec) {
        query.setFirstResult(pageable.getOffset());
        query.setMaxResults(pageable.getPageSize());
        Long total = (Long)this.getCountQuery(spec).getSingleResult();
        return new PageImpl(query.getResultList(), pageable, total.longValue());
    }

    private TypedQuery<T> getQuery(Specification<T> spec, Pageable pageable) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(this.getDomainClass());
        Root<T> root = this.applySpecificationToCriteria(spec, query);
        query.select(root);
        if (pageable != null) {
            query.orderBy(QueryUtils.toOrders(pageable.getSort(), root, builder));
        }
        return this.em.createQuery(query);
    }

    private TypedQuery<T> getQuery(Specification<T> spec, Sort sort) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(this.getDomainClass());
        Root<T> root = this.applySpecificationToCriteria(spec, query);
        query.select(root);
        if (sort != null) {
            query.orderBy(QueryUtils.toOrders(sort, root, builder));
        }
        return this.em.createQuery(query);
    }

    private TypedQuery<Long> getCountQuery(Specification<T> spec) {
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Long.class);
        Root<T> root = this.applySpecificationToCriteria(spec, query);
        query.select((Selection)builder.count(root)).distinct(true);
        return this.em.createQuery(query);
    }

    private <S> Root<T> applySpecificationToCriteria(Specification<T> spec, CriteriaQuery<S> query) {
        Assert.notNull(query);
        Root root = query.from(this.getDomainClass());
        if (spec == null) {
            return root;
        }
        CriteriaBuilder builder = this.em.getCriteriaBuilder();
        Predicate predicate = spec.toPredicate(root, query, builder);
        if (predicate != null) {
            query.where((Expression)predicate);
        }
        return root;
    }
}

