/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.QueryHint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.repository.query.AbstractJpaQuery;
import org.springframework.data.jpa.repository.query.JpaQueryMethod;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.RepositoryQuery;

final class SimpleJpaQuery
extends AbstractJpaQuery {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleJpaQuery.class);
    private final String queryString;
    private final String countQuery;
    private final String alias;
    private final List<QueryHint> hints;
    private final Parameters parameters;

    SimpleJpaQuery(JpaQueryMethod method, EntityManager em, String queryString) {
        super(method, em);
        this.queryString = queryString;
        this.alias = QueryUtils.detectAlias(queryString);
        this.hints = method.getHints();
        this.parameters = method.getParameters();
        this.countQuery = method.getCountQuery() == null ? QueryUtils.createCountQueryFor(queryString) : method.getCountQuery();
        em.createQuery(queryString);
    }

    public Query createQuery(Object[] values) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.parameters, values);
        String sortedQueryString = QueryUtils.applySorting(this.queryString, accessor.getSort(), this.alias);
        Query query = this.getEntityManager().createQuery(sortedQueryString);
        return this.createBinder(values).bindAndPrepare(this.applyHints(query));
    }

    protected Query createCountQuery(Object[] values) {
        return this.createBinder(values).bind(this.applyHints(this.getEntityManager().createQuery(this.countQuery)));
    }

    private Query applyHints(Query query) {
        for (QueryHint hint : this.hints) {
            query.setHint(hint.name(), (Object)hint.value());
        }
        return query;
    }

    public static RepositoryQuery fromQueryAnnotation(JpaQueryMethod queryMethod, EntityManager em) {
        LOG.debug("Looking up query for method {}", (Object)queryMethod.getName());
        String query = queryMethod.getAnnotatedQuery();
        return query == null ? null : new SimpleJpaQuery(queryMethod, em, query);
    }
}

